// keyword_manager.cpp cCve[Vt@C
#include "keyword_manager.h"
#include <ctype.h>                      // __iscsym()
#include <assert.h>                     // assert()


_SGC_BEGIN                              // namespace sgc {


////////////////////////////////////////////////////////////////////////////////
// L[[hݒ
// yz
// @[in]data  c L[[hf[^̔z
//   [in]count c data ̗vf
// y߂lz
// @Ȃ
// yz
// @L[[hf[^x[XɃL[[h count ǉB
void keyword_manager::set_keywords(const keyword_data_t data[], const size_t count)
{
	// o^
	for(uindex_t i = 0; i < count; i++)
	{
		const keyword_t &keyword = data[i].word;
		if(keyword.empty()) { continue; }

		const hash_t hash_val = _Hash(keyword.c_str());
		m_list[hash_val].push_back(data[i]);
	}
	// \[gi~j
	for(uindex_t i = 0; i <= MAX_HASH_VAL; i++)
	{
		m_list[i].sort(_Pred);
	}
}

////////////////////////////////////////////////////////////////////////////////
// 񒆂L[[h
// yz
// @[in] wstr  c L[[h镶
//   [in] lengthc wstr̒
//   [out]info  c L[[h
// y߂lz
// @L[[hꍇAL[[h̒
// @ȂꍇAL[[h܂ł̒
// yz
// @o^ĂL[[hf[^ɃqbgL[[h wstr ̐擪猟B
// @qbgꍇAinfo ɃL[[hݒ肵AL[[h̒ԂB
// @qbgȂꍇÃL[[h܂ł̒ԂB
size_t keyword_manager::find_keyword(const wchar_t *wstr, const size_t length, keyword_info_t &info) const
{
	// L[[h̐擪qbgꏊ
	const uindex_t pos = _FindIndex(wstr, length);

	// ̐擪ȊOŃqbgꍇ
	if(pos > 0)
	{
		// qbgꏊƂ̑Oʕꍇ
		// 񎯕ʕ܂ŃXLbv
		// i"printf""int"qbg悤Ȋj
		size_t length = pos;
		if(_IsIdentifier(wstr[pos]) && _IsIdentifier(wstr[pos - 1]))
		{
			length += _WordLength(&wstr[pos], length - pos);
		}
		info.type = KT_NONE;
		return length;
	}

	// nbVlgp郊Xg
	const hash_t       hash_val = _Hash(wstr);
	const data_list_t &keyword_list = m_list[hash_val];

	// Xg
	for(data_list_t::const_iterator p = keyword_list.begin(); p != keyword_list.end(); p++)
	{
		// L[[hqbg邩H
		const keyword_t &keyword = p->word;
		const int result = _CompareWord(wstr, length, keyword.c_str(), keyword.length());

		if(result == 0)
		{
			// L[[h̃^Cvƒݒ
			info = p->info;
			switch(info.type)
			{
			case KT_NONE:                           // L[[hiȂ̂͗Ȃ͂j
			case KT_NORMAL:                         // ʏL[[h
				return keyword.length();                // L[[h̒Ԃ

			case KT_LINE:                           // sL[[h
				return length;                          // s܂ł̒Ԃ
			}
		}

		if(result > 0 && p->info.type == 0)
		{
			// L[[h͍~Ƀ\[gĂ̂ŁAȍ~̃L[[hɂ̓qbgȂ
			// i񁄃L[[h1L[[h2...j
			// 
			// A񎯕ʕŏIL[[hɂ̓qbg\
			// iF"#x", L[[h"#","#include"  #x > #include > #j
			// 
			// 䂦ɁA񎯕ʕŏIL[[hT
			while(++p != keyword_list.end())
			{
				const keyword_t &keyword = p->word;
				assert(!keyword.empty());
				if(!_IsIdentifier(keyword[keyword.length() - 1]))
				{
					break;
				}
			}
			p--;
		}
	}

	// L[[hqbgȂꍇ
	info.type = KT_NONE;
	return _WordLength(wstr, length);
}


////////////////////////////////////////////////////////////////////////////////////////////////////
// private

////////////////////////////////////////////////////////////////////////////////
// 񂩂nbVlZo
// yz
// @[in]wstr c nbVlZo镶
// y߂lz
// @nbVl
// yz
// @wstr nbVlZoB
// @ZoꂽnbVĺA0ȏMAX_HASH_VALȉ̐łA
// @L[[h邽߂ɎgpB
keyword_manager::hash_t keyword_manager::_Hash(const wchar_t *wstr)
{
	// 擪̉8bitnbVlƂ
	return wstr[0] & 0x00ff;
}

////////////////////////////////////////////////////////////////////////////////
// std::list::sort() ̔r֐
// yz
// @[in]val1 c rf[^1
// @[in]val2 c rf[^2
// y߂lz
// @\[g̏
// yz
// @o^ꂽL[[h\[gۂ̔r֐
bool keyword_manager::_Pred(
	const keyword_manager::keyword_data_t &val1,
	const keyword_manager::keyword_data_t &val2)
{
	// ^CvȂ~Ƀ\[g
	// ~ɂ闝R͈ȉ̒ʂ
	// 1. ܃L[[h̗D
	// @"static_cast""static"ɑ΂āA"double""do"ɑ΂ėDIɌKvB
	// @~Ƀ\[gꍇ͂炪ɗ邽߁ADIɌłB
	// 2. ASCIIȊO̕ɑ΂鍂
	// @Ⴆ΁AUnicodeł'C'(U+2463)̃nbVlU+0063('c')ƂȂB
	// @L[[hɎw肳镶ASCIIقƂǂł邽߁A
	// @'C''c'Ŏn܂Ō̃L[[hiC/C++ł"continue"j傫Ƃ킩
	// @ɃL[[h[`𔲂邱ƂłB
	// @ɂAHTMLTeX̂悤ɁAL[[hASCIIgĂ邪
	// @ȊÔ̕ł悤ȏꍇAL[[hłB
	// @it̏ꍇ͑x邯ǁAj[YƂĂ͈|IɑO҂͂j
	return val1.word > val2.word;
}

////////////////////////////////////////////////////////////////////////////////
// ʕH
// yz
// @[in]wch c ʑΏۂ̕
// y߂lz
// @ʕ̏ꍇA0ȊO
// @񎯕ʕ̏ꍇA0
// yz
// @^ꂽʕǂ𔻕ʂB
// @ʕƂ́A̕AĂPƂĂ݂Ȃ镶̂ƁB
// @iC/C++ł́Ap{A_[XRAj
int keyword_manager::_IsIdentifier(const wchar_t wch)
{
	return iswctype(wch, _ALPHA | _DIGIT);
}


////////////////////////////////////////////////////////////////////////////////
// P̒擾
// yz
// @[in]wstr  c 擾Ώۂ̕
//   [in]lengthc wstr̒
// y߂lz
// @̒
// yz
// @񎯕ʕ܂ł̒vZB
// @Ƃ΁ApʕłȊO񎯕ʕ̏ꍇA
// @_WordLength(L"abcde") = 5, _WordLength(L"abc@") = 3 ƂȂB
// @܂A̐擪ɔ񎯕ʕꂽꍇ1ԂB
size_t keyword_manager::_WordLength(const wchar_t *wstr, const size_t length)
{
	if(length > 0 && !_IsIdentifier(wstr[0])) { return 1; }

	for(size_t i = 0; i < length; i++)
	{
		if(!_IsIdentifier(wstr[i])) { return i; }
	}
	return length;
}


////////////////////////////////////////////////////////////////////////////////
// ̐擪ƃL[[hr
// yz
// @[in] wstr          c 擾Ώۂ̕
//   [in] length_wstr   c wstr̒
// @[in] keyword       c L[[h
//   [in] length_keywordc keyword̒
// @[out]pos           c ŏɕsvꂽꏊ
// y߂lz
// @wstr    @̂قu傫vꍇc̒l
// @keyword @̂قu傫vꍇc̒l
// @wstr  keyword uvꍇc0
// yz
// @{I wcscmp(wstr, keyword) Ɠ
// @Awstr ̐擪 keyword ܂܂ĂĂAP̈ꕔƂ݂Ȃꂽꍇ
// i"international""int"Ȃǁj͐̒lԂ
int keyword_manager::_CompareWord(const wchar_t *wstr, const size_t length_wstr, const wchar_t *keyword, const size_t length_keyword)
{
	for(uindex_t i = 0; i < length_keyword; i++)
	{
		if(i >= length_wstr)
		{
			return -1;
		}

		// vȂΏI
		const int diff = wstr[i] - keyword[i];
		if(diff != 0)
		{
			return diff;
		}
	}

	// P̈ꕔH
	if(length_keyword < length_wstr)
	{
		if(_IsIdentifier(wstr[length_keyword - 1]) && _IsIdentifier(wstr[length_keyword]))
		{
			return 1;
		}
	}
	return 0;
}


////////////////////////////////////////////////////////////////////////////////
// 񒆂ōŏɃL[[h₪ꏊ
// yz
// @[in] wstr    c Ώۂ̕
// @[in] length  c ̒
// y߂lz
// @ŏɃL[[h₪ꏊiCfbNXj
// yz
// @wstr ŁAŏɃL[[h₪ꏊB
// @Ƃ΁A"int"L[[h̒ɂA"printf"̒Tꍇ2ԂB
// @܂AL[[h₪ȂΕ̒ԂB
// @߂l͂܂ŁuvłAmɃL[[hƈvƂۏ؂͂ȂB
uindex_t keyword_manager::_FindIndex(const wchar_t *wstr, const size_t length) const
{
	uindex_t i;
	for(i = 0; i < length; i++)
	{
		// nbVl̂L[[hXgɂ΂̏ꏊԂ
		const unsigned int hash_val = _Hash(&wstr[i]);
		if(m_list[hash_val].size() > 0)
		{
			return i;
		}
	}
	return i;
}

_SGC_END                                // }
