// COM_IDropSource.cpp cCve[Vt@C
#include "COM_IDropSource.h"
#include <assert.h>                     // assert()


_WGC_BEGIN                              // namespace wgc {


////////////////////////////////////////////////////////////
// RXgNV

COM_IDropSource::COM_IDropSource(void)
	: m_lRefCount(0)
{
}

COM_IDropSource::~COM_IDropSource(void)
{
}

// CX^X쐬
IDropSource *COM_IDropSource::CreateInstance(void)
{
	IDropSource *pDropSource = new COM_IDropSource();
	pDropSource->AddRef();

	return pDropSource;
}

HRESULT STDMETHODCALLTYPE COM_IDropSource::QueryInterface(
	REFIID iid,
	void **ppv)
{
	if(IsEqualIID(iid, IID_IUnknown) || IsEqualIID(iid, IID_IDropSource))
	{
		*ppv = this;
		AddRef();
		return S_OK;
	}

	*ppv = NULL;
	return E_NOINTERFACE;
}


ULONG STDMETHODCALLTYPE COM_IDropSource::AddRef()
{
	// QƃJEgCNg
	::InterlockedIncrement(&m_lRefCount);
	return m_lRefCount;
}


ULONG STDMETHODCALLTYPE COM_IDropSource::Release()
{
	assert(m_lRefCount > 0);

	// QƃJEgfNg
	if(::InterlockedDecrement(&m_lRefCount) == 0)
	{
		// 0ɂȂ玩g폜
		delete this;
		return 0;
	}
	return m_lRefCount;
}

// hbOp邩ǂ߂
HRESULT STDMETHODCALLTYPE COM_IDropSource::QueryContinueDrag(
	BOOL fEscapePressed,
	DWORD grfKeyState)
{
	// ESCꂽ璆~
	if(fEscapePressed)
	{
		return DRAGDROP_S_CANCEL;
	}

	// }EX̃{^ꂽ璆~
	const DWORD dwCancelFlag = MK_LBUTTON | MK_RBUTTON;
	if((grfKeyState & dwCancelFlag) == dwCancelFlag)
	{
		return DRAGDROP_S_CANCEL;
	}

	// }EX{^ꂽhbv
	const DWORD dwDropFlag = MK_LBUTTON | MK_RBUTTON;
	if((grfKeyState & dwDropFlag) == 0)
	{
		return DRAGDROP_S_DROP;
	}

	return S_OK;
}

HRESULT STDMETHODCALLTYPE COM_IDropSource::GiveFeedback(
	DWORD /* dwEffect */)
{
	return DRAGDROP_S_USEDEFAULTCURSORS;
}

_WGC_END                                // }
