// Dialog.h c_CAO{bNX̃TuNX
#ifndef __WGC_DIALOG__
#define __WGC_DIALOG__

#include "Window.h"
#include "Control.h"
#include "ToolTipCtrl.h"


_WGC_BEGIN                              // namespace wgc {

class Dialog : public Window
{
public:
	// RXgN^^fXgN^
	Dialog(HINSTANCE hResource, LPCTSTR lpTemplate, HWND hWndParent = NULL);
	~Dialog(void);

	// _CAO̕\^I
	virtual INT_PTR DoModal   (const LPARAM dwInitParam = 0);   // [_\
	virtual BOOL    DoModeless(const LPARAM dwInitParam = 0);   // [hX\

	// bZ[W֐
	LRESULT SendDlgItemMessage(const int nIDDlgItem, const UINT uMsg, const WPARAM wParam = 0, const LPARAM lParam = 0);
	BOOL    IsDialogMessage(LPMSG lpMsg);

	// `FbN{^֐
	UINT IsDlgButtonChecked   (const int nIDButton) const;
	BOOL CheckDlgButton       (const int nIDButton, const UINT uCheck);
	BOOL CheckRadioButton     (const int nIDFirstButton, const int nIDLastButton, const int nIDCheckButton);
	int  GetCheckedRadioButton(const int nIDFirstButton, const int nIDLastButton);

	// bp֐
	UINT GetDlgItemInt(const int nIDDlgItem, BOOL *lpTranslated, const BOOL bSigned = TRUE);
	void SetDlgItemInt(const int nIDDlgItem, const UINT nValue , const BOOL bSigned = TRUE);
	UINT GetDlgItemText(const int nIDDlgItem, tstring_t &tstr);
	void SetDlgItemText(const int nIDDlgItem, const tstring_t &tstr);

	HWND SetDlgItemFocus(const int nIDDlgItem);

private:
	// c[`bv
	wgc::ToolTipCtrl m_ctrlToolTip;
	void InitToolTips(void);

protected:
	HINSTANCE m_hResource;                  // _CAÕ\[Xnh
	LPCTSTR   m_lpszTemplateName;           // _CAOev[g
	HWND      m_hWndParent;                 // eEChE

	// c[`bv֘A
	void SetToolTips(const UINT arID[], const UINT nIDCount);
	void SetToolTip (const UINT nID);

	// bp֐
	void EndDialog(const int nResult);      // [__CAȌI
	void EndModeless(void);                 // [hX_CAȌI

	// TuNX
	void Subclass(HWND hWnd);
	void Unsubclass(void);

	// z֐
	virtual void AssociateDialogControls(void) = 0;
	virtual void UpdateData(const BOOL bUpdate = TRUE) = 0;

	// _CAOvV[W
	LRESULT WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam);
	LRESULT _Default(void);


	// _CAObZ[Wnh
	virtual BOOL OnInitDialog(HWND hWndFocus, const LPARAM dwInitParam);

	BOOL OnCommand(const WORD wNotifyCode, const WORD wID, HWND hWndCtrl);

	virtual void OnOK(void);                // OK{^
	virtual void OnCancel(void);            // LZ{^
};

_WGC_END                                // }

#endif // __WGC_DIALOG__
