// GdiObject.h cGDIIuWFNgNX
#ifndef __WGC_GDIOBJECT__
#define __WGC_GDIOBJECT__

#include "wgc.h"
#include <windows.h>


_WGC_BEGIN                              // namespace wgc {

class GdiObject
{
public:
	GdiObject(HGDIOBJ hObject);
	virtual ~GdiObject(void);

	// Rs[RXgN^Zq
	GdiObject            (GdiObject &rObject);
	GdiObject &operator =(GdiObject &rObject);

	operator HGDIOBJ(void) {return m_hObject;}

protected:
	BOOL    m_bOwner;
	HGDIOBJ m_hObject;

	BOOL Delete(void);
};


////////////////////////////////////////////////////////////
// hGDIIuWFNg

// y
class GdiPen : public GdiObject
{
public:
	GdiPen(HPEN hPen);
	GdiPen(const int fnPenStyle, const int nWidth, const COLORREF crColor);
	~GdiPen(void);

	operator HPEN(void) { return reinterpret_cast<HPEN>(m_hObject); }
};

// tHg
class GdiFont : public GdiObject
{
public:
	GdiFont(HFONT hFont);
	GdiFont(
		const int nPointSize, LPCTSTR lpszFaceName,
		const BOOL bBold      = FALSE, const BOOL bItalic    = FALSE,
		const BOOL bUnderline = FALSE, const BOOL bStrikeOut = FALSE);

	~GdiFont(void);

	operator HFONT(void) { return reinterpret_cast<HFONT>(m_hObject); }

private:
	HFONT CreatePointFont(
		const DOUBLE fPointSize, LPCTSTR lpszFaceName,
		const BOOL bBold      = FALSE, const BOOL bItalic    = FALSE,
		const BOOL bUnderline = FALSE, const BOOL bStrikeOut = FALSE);
};

_WGC_END                                // }

#endif // __WGC_GDIOBJECT__
