// ListBoxCtrl.cpp cCve[Vt@C
#include "ListBoxCtrl.h"
#include "wgfunc.h"
#include <vector>


_WGC_BEGIN                              // namespace wgc {

// RXgN^
ListBoxCtrl::ListBoxCtrl(HWND hWnd /* = NULL */) : Control(hWnd)
{
}

// fXgN^
ListBoxCtrl::~ListBoxCtrl(void)
{
}

UINT ListBoxCtrl::InitStorage(const UINT uItems, const UINT uBytes)
{
	const LRESULT lResult = SendMessage(LB_INITSTORAGE, uItems, uBytes);
	if(lResult < 0)
	{
		wgfThrowLastError();
	}
	return static_cast<UINT>(lResult);
}


// ֘Atf[^
void ListBoxCtrl::SetItemData(const UINT uIndex, const DWORD_PTR dwItemData)
{
	const LRESULT lResult = SendMessage(LB_SETITEMDATA, uIndex, dwItemData);
	if(lResult == LB_ERR)
	{
		wgfThrowLastError();
	}
}

DWORD_PTR ListBoxCtrl::GetItemData(const UINT uIndex) const
{
	const LRESULT lResult = SendMessage(LB_GETITEMDATA, uIndex);
	if(lResult == LB_ERR)
	{
		wgfThrowLastError();
	}
	return lResult;
}


// eLXg擾
SIZE_T ListBoxCtrl::GetText(const UINT uIndex, LPTSTR lpszBuffer) const
{
	const LRESULT lResult = SendMessage(LB_GETTEXT, uIndex, reinterpret_cast<LPARAM>(lpszBuffer));
	if(lResult == LB_ERR)
	{
		wgfThrowLastError();
	}
	return lResult;
}

void ListBoxCtrl::GetText(const UINT uIndex, tstring_t &rString) const
{
	const SIZE_T buffer_size = GetTextLen(uIndex);
	std::vector<TCHAR> buffer(buffer_size);
	GetText(uIndex, &buffer[0]);

	rString.assign(&buffer[0], buffer.size());
}

SIZE_T ListBoxCtrl::GetTextLen(const UINT uIndex) const
{
	const LRESULT lResult = SendMessage(LB_GETTEXTLEN, uIndex);
	if(lResult == LB_ERR)
	{
		wgfThrowLastError();
	}
	return lResult;
}


// eLXgݒ
UINT ListBoxCtrl::AddString(LPCTSTR lpszItem)
{
	const LRESULT lResult = SendMessage(LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(lpszItem));
	if(lResult < 0)
	{
		wgfThrowLastError();
	}
	return static_cast<UINT>(lResult);
}

UINT ListBoxCtrl::AddString(const tstring_t &rString)
{
	return AddString(rString.c_str());
}

UINT ListBoxCtrl::InsertString(const int nIndex, LPCTSTR lpszItem)
{
	const LRESULT lResult = SendMessage(LB_INSERTSTRING, nIndex, reinterpret_cast<LPARAM>(lpszItem));
	if(lResult < 0)
	{
		wgfThrowLastError();
	}
	return static_cast<UINT>(lResult);
}

UINT ListBoxCtrl::InsertString(const int nIndex, const tstring_t &rString)
{
	return InsertString(nIndex, rString.c_str());
}


// ACe
UINT ListBoxCtrl::GetCount(void) const
{
	const LRESULT lResult = SendMessage(LB_GETCOUNT);
	if(lResult == LB_ERR)
	{
		wgfThrowLastError();
	}
	return static_cast<UINT>(lResult);
}


// PI
int ListBoxCtrl::GetCurSel(void) const
{
	const LRESULT lResult = SendMessage(LB_GETCURSEL);
	if(lResult == LB_ERR)
	{
		return -1;
	}
	return static_cast<int>(lResult);
}

void ListBoxCtrl::SetCurSel(const int nIndex /* = -1 */)
{
	const LRESULT lResult = SendMessage(LB_SETCURSEL, nIndex);
	if(lResult == LB_ERR)
	{
		wgfThrowLastError();
	}
}


// I
BOOL ListBoxCtrl::GetSel(const UINT uIndex) const
{
	const LRESULT lResult = SendMessage(LB_GETSEL, uIndex);
	if(lResult == LB_ERR)
	{
		wgfThrowLastError();
	}
	return (lResult > 0);
}

void ListBoxCtrl::SetSel(const int nIndex /* = -1 */, const BOOL bSelect /* = TRUE */)
{
	const LRESULT lResult = SendMessage(LB_SETSEL, bSelect, nIndex);
	if(lResult == LB_ERR)
	{
		wgfThrowLastError();
	}
}

UINT ListBoxCtrl::GetSelCount(void) const
{
	const LRESULT lResult = SendMessage(LB_GETSELCOUNT);
	if(lResult == LB_ERR)
	{
		wgfThrowLastError();
	}
	return static_cast<UINT>(lResult);
}

_WGC_END                                // }
