// LNX
#ifndef __SHARED_MEMORY__
#define __SHARED_MEMORY__

#include "wgc.h"
#include <assert.h>


_WGC_BEGIN

// LNX
template<typename _Ty>
class SharedMemory
{
public:
	SharedMemory(LPCTSTR lpszName) : m_hSharedMemory(NULL), m_lpSharedData(NULL)
	{
		m_hSharedMemory = ::CreateFileMapping(
			INVALID_HANDLE_VALUE,
			NULL,
			PAGE_READWRITE,
			0, sizeof(_Ty),
			lpszName);
		if(m_hSharedMemory == NULL)
		{
			wgfThrowLastError();
		}
	}
	~SharedMemory(void)
	{
		::CloseHandle(m_hSharedMemory);
		m_hSharedMemory = NULL;
	}

	_Ty *GetData(const DWORD dwDesiredAccess = FILE_MAP_READ)
	{
		// }bv
		LPVOID lpData = ::MapViewOfFile(
			m_hSharedMemory,
			dwDesiredAccess,
			0, 0, 0);

		if(lpData == NULL)
		{
			wgfThrowLastError();
		}

		// f[^Rs[
		return reinterpret_cast<_Ty *>(lpData);
	}
	void ReleaseData(_Ty *lpData)
	{
		assert(lpData != NULL);
		::UnmapViewOfFile(lpData);
	}

private:
	HANDLE m_hSharedMemory;
	_Ty   *m_lpSharedData;
};

_WGC_END

#endif // __SHARED_MEMORY__
