/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.Verifiable;
import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.CallBag;
import com.mockobjects.dynamic.CallFactory;
import com.mockobjects.dynamic.CallSequence;
import com.mockobjects.dynamic.CallableAddable;
import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.DefaultCallFactory;
import com.mockobjects.dynamic.FullConstraintMatcher;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import junit.framework.AssertionFailedError;

public class Mock
implements InvocationHandler,
Verifiable {
    private String name;
    private Object proxy;
    private CallFactory callFactory;
    private CallableAddable callSequence;

    public Mock(CallFactory callFactory, CallableAddable callableAddable, Class mockedClass, String name) {
        this.name = name;
        this.callFactory = callFactory;
        this.callSequence = callableAddable;
        this.proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{mockedClass}, (InvocationHandler)this);
    }

    public Mock(Class mockedClass, String nonDefaultName) {
        this(new DefaultCallFactory(), new CallBag(), mockedClass, nonDefaultName);
    }

    public Mock(Class mockedClass) {
        this(mockedClass, Mock.mockNameFromClass(mockedClass));
    }

    public void reset() {
        this.callSequence.reset();
    }

    public static String mockNameFromClass(Class c) {
        return "mock" + Mock.className(c);
    }

    public static String className(Class c) {
        String name = c.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex >= 0) {
            return name.substring(dotIndex + 1);
        }
        return name;
    }

    private ConstraintMatcher createConstraintMatcher(Object constraintArg) {
        if (constraintArg instanceof Constraint[]) {
            return new FullConstraintMatcher((Constraint[])constraintArg);
        }
        if (constraintArg instanceof Constraint) {
            return C.args((Constraint)constraintArg);
        }
        return C.args(C.eq(constraintArg));
    }

    public String getMockName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Object proxy() {
        return this.proxy;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (this.isCheckingEqualityOnProxy(method, args)) {
                return new Boolean(args[0] == this.proxy);
            }
            if (this.isMockNameGetter(method, args)) {
                return this.getMockName();
            }
            return this.callSequence.call(this, method.getName(), args == null ? new Object[]{} : args);
        }
        catch (AssertionFailedError ex) {
            throw new AssertionFailedError(this.name + ": " + ex.getMessage());
        }
    }

    private boolean isCheckingEqualityOnProxy(Method method, Object[] args) {
        return method.getName().equals("equals") && args.length == 1 && Proxy.isProxyClass(args[0].getClass());
    }

    private boolean isMockNameGetter(Method method, Object[] args) {
        return method.getName().equals("getMockName") && args.length == 0;
    }

    public void verify() {
        try {
            this.callSequence.verify();
        }
        catch (AssertionFailedError ex) {
            throw new AssertionFailedError(this.name + ": " + ex.getMessage());
        }
    }

    public void expect(String methodName) {
        this.expect(methodName, C.NO_ARGS);
    }

    public void expect(String methodName, Object singleEqualArg) {
        this.expect(methodName, this.createConstraintMatcher(singleEqualArg));
    }

    public void expect(String methodName, ConstraintMatcher args) {
        this.callSequence.addExpect(this.callFactory.createCallExpectation(this.callFactory.createCallSignature(methodName, args, this.callFactory.createVoidStub())));
    }

    public void expectAndReturn(String methodName, Object result) {
        this.expectAndReturn(methodName, C.NO_ARGS, result);
    }

    public void expectAndReturn(String methodName, boolean result) {
        this.expectAndReturn(methodName, new Boolean(result));
    }

    public void expectAndReturn(String methodName, int result) {
        this.expectAndReturn(methodName, new Integer(result));
    }

    public void expectAndReturn(String methodName, Object singleEqualArg, Object result) {
        this.expectAndReturn(methodName, this.createConstraintMatcher(singleEqualArg), result);
    }

    public void expectAndReturn(String methodName, Object singleEqualArg, boolean result) {
        this.expectAndReturn(methodName, singleEqualArg, (Object)new Boolean(result));
    }

    public void expectAndReturn(String methodName, Object singleEqualArg, int result) {
        this.expectAndReturn(methodName, singleEqualArg, (Object)new Integer(result));
    }

    public void expectAndReturn(String methodName, ConstraintMatcher args, Object result) {
        this.callSequence.addExpect(this.callFactory.createCallExpectation(this.callFactory.createCallSignature(methodName, args, this.callFactory.createReturnStub(result))));
    }

    public void expectAndReturn(String methodName, ConstraintMatcher args, boolean result) {
        this.expectAndReturn(methodName, args, (Object)new Boolean(result));
    }

    public void expectAndReturn(String methodName, ConstraintMatcher args, int result) {
        this.expectAndReturn(methodName, args, (Object)new Integer(result));
    }

    public void expectAndThrow(String methodName, Throwable exception) {
        this.expectAndThrow(methodName, C.NO_ARGS, exception);
    }

    public void expectAndThrow(String methodName, Object singleEqualArg, Throwable exception) {
        this.expectAndThrow(methodName, this.createConstraintMatcher(singleEqualArg), exception);
    }

    public void expectAndThrow(String methodName, ConstraintMatcher args, Throwable exception) {
        this.callSequence.addExpect(this.callFactory.createCallExpectation(this.callFactory.createCallSignature(methodName, args, this.callFactory.createThrowStub(exception))));
    }

    public void matchAndReturn(String methodName, Object result) {
        this.matchAndReturn(methodName, C.NO_ARGS, result);
    }

    public void matchAndReturn(String methodName, boolean result) {
        this.matchAndReturn(methodName, new Boolean(result));
    }

    public void matchAndReturn(String methodName, int result) {
        this.matchAndReturn(methodName, new Integer(result));
    }

    public void matchAndReturn(String methodName, Object singleEqualArg, Object result) {
        this.matchAndReturn(methodName, this.createConstraintMatcher(singleEqualArg), result);
    }

    public void matchAndReturn(String methodName, boolean singleEqualArg, Object result) {
        this.matchAndReturn(methodName, (Object)new Boolean(singleEqualArg), result);
    }

    public void matchAndReturn(String methodName, int singleEqualArg, Object result) {
        this.matchAndReturn(methodName, (Object)new Integer(singleEqualArg), result);
    }

    public void matchAndReturn(String methodName, Object singleEqualArg, boolean result) {
        this.matchAndReturn(methodName, singleEqualArg, (Object)new Boolean(result));
    }

    public void matchAndReturn(String methodName, Object singleEqualArg, int result) {
        this.matchAndReturn(methodName, singleEqualArg, (Object)new Integer(result));
    }

    public void matchAndReturn(String methodName, ConstraintMatcher args, Object result) {
        this.callSequence.addMatch(this.callFactory.createCallSignature(methodName, args, this.callFactory.createReturnStub(result)));
    }

    public void matchAndReturn(String methodName, ConstraintMatcher args, boolean result) {
        this.matchAndReturn(methodName, args, (Object)new Boolean(result));
    }

    public void matchAndReturn(String methodName, ConstraintMatcher args, int result) {
        this.matchAndReturn(methodName, args, (Object)new Integer(result));
    }

    public void matchAndThrow(String methodName, Throwable throwable) {
        this.matchAndThrow(methodName, C.NO_ARGS, throwable);
    }

    public void matchAndThrow(String methodName, Object singleEqualArg, Throwable throwable) {
        this.matchAndThrow(methodName, this.createConstraintMatcher(singleEqualArg), throwable);
    }

    public void matchAndThrow(String methodName, boolean singleEqualArg, Throwable throwable) {
        this.matchAndThrow(methodName, new Boolean(singleEqualArg), throwable);
    }

    public void matchAndThrow(String methodName, int singleEqualArg, Throwable throwable) {
        this.matchAndThrow(methodName, new Integer(singleEqualArg), throwable);
    }

    public void matchAndThrow(String methodName, ConstraintMatcher args, Throwable throwable) {
        this.callSequence.addMatch(this.callFactory.createCallSignature(methodName, args, this.callFactory.createThrowStub(throwable)));
    }

    public void expect(String methodName, CallSequence deprecated) {
        throw new AssertionFailedError("method is deprecated! Use: new OrderedMock() instead...");
    }

    public void expectAndReturn(String methodName, CallSequence deprecated, Object result) {
        throw new AssertionFailedError("method is deprecated! Use: new OrderedMock() instead...");
    }

    public void expectAndThrow(String methodName, CallSequence deprecated, Throwable throwable) {
        throw new AssertionFailedError("method is deprecated! Use: new OrderedMock() instead...");
    }

    public void expectVoid(String methodName, ConstraintMatcher args) {
        this.expect(methodName, args);
    }

    public void expectVoid(String methodName, Object equalArg) {
        this.expect(methodName, equalArg);
    }

    public void expectVoid(String methodName) {
        this.expect(methodName);
    }

    public void expectNotCalled(String methodName) {
    }
}

