/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.enhydra.jdbc.standard.StandardPreparedStatement;
import org.enhydra.jdbc.standard.StandardXAConnectionHandle;

public class StandardXAPreparedStatement
extends StandardPreparedStatement {
    private StandardXAConnectionHandle con;
    public String sql;
    public int resultSetType;
    public int resultSetConcurrency;

    StandardXAPreparedStatement(StandardXAConnectionHandle con_, String sql_, int resultSetType_, int resultSetConcurrency_) throws SQLException {
        this.con = con_;
        this.sql = sql_;
        this.key = sql_ + resultSetType_ + resultSetConcurrency_;
        this.resultSetType = resultSetType_;
        this.resultSetConcurrency = resultSetConcurrency_;
        this.log = con_.log;
        this.log.debug("StandardXAPreparedStatement: Create an XAPreparedStatement with sql='" + this.sql + "'");
        this.key = this.sql + this.resultSetType + this.resultSetConcurrency + (this.con.tx != null);
        this.ps = this.con.checkPreparedCache(this.sql, this.resultSetType, this.resultSetConcurrency, this.key);
    }

    public synchronized void close() throws SQLException {
        this.log.debug("StandardXAPreparedStatement:close the XA prepared statement");
        this.closed = true;
        if (this.con.preparedStmtCacheSize == 0) {
            this.log.debug("StandardXAPreparedStatement:close preparedStmtCacheSize == 0");
            if (this.ps != null) {
                this.ps.close();
            }
        } else {
            this.log.debug("StandardXAPreparedStatement:close preparedStmtCacheSize='" + this.con.preparedStmtCacheSize + "'");
            this.con.returnToCache(this.key);
        }
    }

    public synchronized void preInvoke() throws SQLException {
        this.log.warn("** StandardXAPreparedStatement:preInvoke this methodis no longer used!!! **");
        if (this.closed) {
            throw new SQLException("StandardXAPreparedStatement:preinvoke Prepare Statement is closed");
        }
        Transaction ntx = null;
        Connection oldCon = this.con.con;
        if (this.log == null) {
            this.log = this.con.log;
        }
        if (this.con.tx == null) {
            try {
                try {
                    Transaction transaction = ntx = this.con.transactionManager != null ? this.con.transactionManager.getTransaction() : null;
                    if (ntx != null) {
                        this.con.tx = ntx;
                        this.con.setAutoCommit(false);
                        if (this.ps != null) {
                            this.con.returnToCache(this.key, oldCon);
                            this.ps = null;
                        }
                    }
                }
                catch (SystemException n) {
                    n.printStackTrace();
                    throw new SQLException("StandardXAPreparedStatement:preInvoke getTransaction exception: " + n.toString());
                }
            }
            catch (NullPointerException n) {
                n.printStackTrace();
                throw new SQLException("StandardXAPreparedStatement:preInvoke should not be used outside an EJBServer");
            }
        }
        if (this.ps == null) {
            this.key = this.sql + this.resultSetType + this.resultSetConcurrency + (this.con.tx != null);
            this.ps = this.con.checkPreparedCache(this.sql, this.resultSetType, this.resultSetConcurrency, this.key);
        }
    }

    public void catchInvoke(SQLException sqlException) throws SQLException {
        throw sqlException;
    }
}

