/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.TraceTm;

public class XidImpl
implements Xid,
Serializable {
    public static final int JONAS_FORMAT_ID = 47892;
    private static int count = 1;
    private int formatId;
    private byte[] gtrid;
    private byte[] bqual;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XidImpl(String serverName, int ipAddr) {
        long uuid;
        TraceTm.jotm.debug((Object)("serverName=" + serverName + ", ipAddr=" + ipAddr));
        this.formatId = 47892;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            uuid = System.currentTimeMillis() * 1024L + (long)count;
            ++count;
        }
        String s = Long.toHexString(uuid) + "_" + Long.toHexString(ipAddr) + "_" + serverName;
        if (s.length() > 64) {
            s = s.substring(0, 64);
        }
        this.gtrid = s.getBytes();
        this.bqual = s.getBytes();
        TraceTm.jotm.debug((Object)("new Xid (uuid=" + uuid + ")"));
    }

    public XidImpl(int fid, int bqualsz, byte[] tid) {
        TraceTm.jotm.debug((Object)"constructor from otid_t");
        this.formatId = fid;
        int gtridsz = tid.length - bqualsz;
        this.gtrid = new byte[gtridsz];
        System.arraycopy(tid, bqualsz, this.gtrid, 0, gtridsz);
        this.bqual = new byte[bqualsz];
        System.arraycopy(tid, 0, this.bqual, 0, bqualsz);
    }

    public XidImpl(int formatId, byte[] gtrid, byte[] bqual) {
        this.formatId = formatId;
        this.gtrid = gtrid;
        this.bqual = bqual;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public String toString() {
        return new String(this.bqual) + new String(this.gtrid);
    }

    public boolean equals(Object obj2) {
        XidImpl xid2 = (XidImpl)obj2;
        return this.formatId == xid2.getFormatId() && Arrays.equals(this.bqual, xid2.getBranchQualifier()) && Arrays.equals(this.gtrid, xid2.getGlobalTransactionId());
    }

    public int hashCode() {
        String bquals = new String(this.bqual);
        String gtrids = new String(this.gtrid);
        return (gtrids + bquals).hashCode() % 100;
    }
}

