/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm.jta.rmi;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInfo;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JServiceContext;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.jta.rmi.JTATransactionServiceContext;

public class JTAServerTransactionInterceptor
implements JServerRequestInterceptor {
    private static Log log = LogFactory.getLog((String)"org.objectweb.jotm.jta.rmi.server");
    public static int TX_CTX_ID = 0;
    private static Current current = null;
    private static String interceptorName = "JTAServerTransactionInterceptor";

    public JTAServerTransactionInterceptor() {
        log.trace((Object)"default constructor");
    }

    public void receive_request(JServerRequestInfo jri) throws IOException {
        JTATransactionServiceContext jtasc;
        log.trace((Object)"--> receive request");
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (jtasc = (JTATransactionServiceContext)jri.get_request_service_context(TX_CTX_ID)) != null) {
            current.setPropagationContext(jtasc.getTransactionContext(), false);
        }
    }

    public void send_reply(JServerRequestInfo jri) throws IOException {
        TransactionContext txCtx;
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (txCtx = current.getPropagationContext(false)) != null) {
            JTATransactionServiceContext jtasc = new JTATransactionServiceContext();
            jtasc.setContext(txCtx, true);
            jri.add_reply_service_context((JServiceContext)jtasc);
            current.setPropagationContext(null, false);
        }
        log.trace((Object)"<-- sent reply");
    }

    public String name() {
        return interceptorName;
    }

    public void send_exception(JServerRequestInfo jri) throws IOException {
        TransactionContext txCtx;
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (txCtx = current.getPropagationContext(false)) != null) {
            JTATransactionServiceContext jtasc = new JTATransactionServiceContext();
            jtasc.setContext(txCtx, true);
            jri.add_reply_service_context((JServiceContext)jtasc);
            current.setPropagationContext(null, false);
        }
        log.trace((Object)"<-- sent exception");
    }

    public void send_other(JServerRequestInfo jri) throws IOException {
        TransactionContext txCtx;
        if (current == null) {
            current = Current.getCurrent();
        }
        if (current != null && (txCtx = current.getPropagationContext(false)) != null) {
            JTATransactionServiceContext jtasc = new JTATransactionServiceContext();
            jtasc.setContext(txCtx, true);
            jri.add_reply_service_context((JServiceContext)jtasc);
            current.setPropagationContext(null, false);
        }
        log.trace((Object)"<-- sent other");
    }
}

