/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.easymock.internal.AbstractBehavior;
import org.easymock.internal.MethodCall;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.ResultList;

public class OrderedBehavior
extends AbstractBehavior {
    private List methodCalls = new ArrayList();
    private List resultLists = new ArrayList();
    private int position = 0;

    public void addExpected(MethodCall methodCall, Result result, Range range) {
        if (!this.lastMethodCallEqualTo(methodCall)) {
            this.methodCalls.add(methodCall);
            this.resultLists.add(new ResultList());
        }
        ResultList resultList = (ResultList)this.resultLists.get(this.resultLists.size() - 1);
        resultList.add(result, range);
    }

    private boolean lastMethodCallEqualTo(MethodCall methodCall) {
        if (this.methodCalls.isEmpty()) {
            return false;
        }
        MethodCall lastMethodCall = (MethodCall)this.methodCalls.get(this.methodCalls.size() - 1);
        return lastMethodCall.equals(methodCall);
    }

    public Result addActual2(Method actualMethod, Object[] actualParameters) {
        ArrayList<MethodCall> matchedCalls = new ArrayList<MethodCall>();
        ArrayList<ResultList> matchedResultLists = new ArrayList<ResultList>();
        int tooManyCallsPosition = -1;
        while (this.position < this.methodCalls.size()) {
            MethodCall expectedCall = (MethodCall)this.methodCalls.get(this.position);
            ResultList resultList = (ResultList)this.resultLists.get(this.position);
            if (expectedCall.getMethod().equals(actualMethod) && this.getMatcher(expectedCall.getMethod()).matches(expectedCall.getParameters(), actualParameters)) {
                Result result = resultList.next();
                if (result != null) {
                    return result;
                }
                matchedCalls.add(expectedCall);
                matchedResultLists.add(resultList);
                tooManyCallsPosition = matchedCalls.size() - 1;
            } else if (!resultList.hasValidCallCount()) {
                matchedCalls.add(expectedCall);
                matchedResultLists.add(resultList);
                break;
            }
            ++this.position;
        }
        Result defaultBehavior = this.getDefaultBehavior(actualMethod);
        if (defaultBehavior != null) {
            return defaultBehavior;
        }
        throw new AssertionFailedError(this.createFailureMessage(actualMethod, actualParameters, matchedCalls, matchedResultLists, tooManyCallsPosition));
    }

    private String createFailureMessage(Method actualMethod, Object[] actualParameters, List matchedCalls, List matchedResultLists, int tooManyCallsPosition) {
        String failureMessage = "";
        if (tooManyCallsPosition == -1) {
            failureMessage = failureMessage + "\n    " + new MethodCall(actualMethod, actualParameters).toString(this.getMatcher(actualMethod)) + ": " + new Range(2).expectedAndActual(1).replace('2', '0');
        }
        int i = 0;
        while (i < matchedCalls.size()) {
            MethodCall call = (MethodCall)matchedCalls.get(i);
            Method method = call.getMethod();
            Object[] parameters = call.getParameters();
            ResultList list = (ResultList)matchedResultLists.get(i);
            failureMessage = failureMessage + "\n    " + new MethodCall(method, parameters).toString(this.getMatcher(method)) + ": ";
            int count = list.getCallCount() + (i == tooManyCallsPosition ? 1 : 0);
            failureMessage = failureMessage + list.getMessage(count);
            ++i;
        }
        return failureMessage;
    }

    public void verify2() {
        String failureMessage = "";
        boolean verifyFailed = false;
        int i = this.position;
        while (i < this.methodCalls.size()) {
            MethodCall call = (MethodCall)this.methodCalls.get(i);
            ResultList list = (ResultList)this.resultLists.get(i);
            failureMessage = failureMessage + "\n    " + call.toString(this.getMatcher(call.getMethod())) + ": " + list.getMessage();
            if (!list.hasValidCallCount()) {
                verifyFailed = true;
            }
            ++i;
        }
        if (verifyFailed) {
            throw new AssertionFailedError(failureMessage);
        }
    }
}

