/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

public class Range {
    private int minimum;
    private int maximum;

    public Range(int count) {
        this(count, count);
    }

    public Range(int minimum, int maximum) {
        if (minimum > maximum) {
            throw new IllegalArgumentException("minimum must be <= maximum");
        }
        if (minimum < 0) {
            throw new IllegalArgumentException("minimum must be >= 0");
        }
        if (maximum < 1) {
            throw new IllegalArgumentException("maximum must be >= 1");
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    boolean containsMoreThanOneCount() {
        return this.minimum < this.maximum;
    }

    int getMaximum() {
        return this.maximum;
    }

    int getMinimum() {
        return this.minimum;
    }

    public String toString() {
        if (!this.containsMoreThanOneCount()) {
            return "" + this.minimum;
        }
        if (this.maximum == Integer.MAX_VALUE) {
            return "at least " + this.minimum;
        }
        return "between " + this.minimum + " and " + this.maximum;
    }

    public String expectedAndActual(int count) {
        return "expected: " + this + ", actual: " + count;
    }

    boolean contains(int count) {
        return this.minimum <= count && count <= this.maximum;
    }

    boolean hasOpenCount() {
        return this.maximum == Integer.MAX_VALUE;
    }
}

