/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.easymock.internal.AbstractBehavior;
import org.easymock.internal.MethodCall;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.ResultListMap;

public class UnorderedBehavior
extends AbstractBehavior {
    private Map methodBehaviors = new HashMap();

    private ResultListMap getMethodBehavior(Method method) {
        if (!this.methodBehaviors.containsKey(method)) {
            this.methodBehaviors.put(method, new ResultListMap(method, this.getMatcher(method)));
        }
        return (ResultListMap)this.methodBehaviors.get(method);
    }

    public void addExpected(MethodCall call, Result returnValue, Range range) {
        ResultListMap behaviors = this.getMethodBehavior(call.getMethod());
        behaviors.addExpected(call.getParameters(), returnValue, range);
    }

    protected Result returnValueForUnexpected(Method method) {
        return null;
    }

    public Result addActual2(Method actualMethod, Object[] actualParameters) {
        ResultListMap behavior = this.getMethodBehavior(actualMethod);
        try {
            return behavior.addActual(actualParameters);
        }
        catch (AssertionFailedError e) {
            Result defaultBehavior = this.getDefaultBehavior(actualMethod);
            if (defaultBehavior != null) {
                return defaultBehavior;
            }
            Result niceBehavior = this.returnValueForUnexpected(actualMethod);
            if (niceBehavior != null) {
                return niceBehavior;
            }
            throw new AssertionFailedError(e.getMessage());
        }
    }

    public void verify2() {
        String failureMessage = "";
        boolean verifyFailed = false;
        Iterator it = this.methodBehaviors.keySet().iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            try {
                this.getMethodBehavior(method).verify();
            }
            catch (AssertionFailedError e) {
                verifyFailed = true;
                failureMessage = failureMessage + e.getMessage();
            }
        }
        if (!verifyFailed) {
            return;
        }
        throw new AssertionFailedError(failureMessage);
    }
}

