/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.builder.xml;

import com.ibatis.common.beans.BeanProbe;
import com.ibatis.common.io.ReaderInputStream;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.accessplan.AccessPlanFactory;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapClasspathEntityResolver;
import com.ibatis.sqlmap.engine.builder.xml.XmlConverter;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.datasource.DataSourceFactory;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.parameter.BasicParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.BasicParameterMapping;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.AutoResultMap;
import com.ibatis.sqlmap.engine.mapping.result.BasicResultMap;
import com.ibatis.sqlmap.engine.mapping.result.BasicResultMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.sql.SqlText;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.DynamicSql;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.DynamicParent;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTag;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagHandler;
import com.ibatis.sqlmap.engine.mapping.sql.dynamic.elements.SqlTagHandlerFactory;
import com.ibatis.sqlmap.engine.mapping.sql.simple.SimpleDynamicSql;
import com.ibatis.sqlmap.engine.mapping.sql.stat.StaticSql;
import com.ibatis.sqlmap.engine.mapping.statement.CachingStatement;
import com.ibatis.sqlmap.engine.mapping.statement.DeleteStatement;
import com.ibatis.sqlmap.engine.mapping.statement.GeneralStatement;
import com.ibatis.sqlmap.engine.mapping.statement.InsertStatement;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.ProcedureStatement;
import com.ibatis.sqlmap.engine.mapping.statement.SelectKeyStatement;
import com.ibatis.sqlmap.engine.mapping.statement.SelectStatement;
import com.ibatis.sqlmap.engine.mapping.statement.UpdateStatement;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.transaction.TransactionConfig;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlSqlMapClientBuilder {
    private static final Log log = LogFactory.getLog((Class)(class$com$ibatis$sqlmap$engine$builder$xml$XmlSqlMapClientBuilder == null ? (class$com$ibatis$sqlmap$engine$builder$xml$XmlSqlMapClientBuilder = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.builder.xml.XmlSqlMapClientBuilder")) : class$com$ibatis$sqlmap$engine$builder$xml$XmlSqlMapClientBuilder));
    private static final String NODE_PROPERTIES = "properties";
    private static final String NODE_SETTINGS = "settings";
    private static final String NODE_TX_MANAGER = "transactionManager";
    private static final String NODE_DATA_SOURCE = "dataSource";
    private static final String NODE_PROPERTY = "property";
    private static final String NODE_SQL_MAP = "sqlMap";
    private static final String NODE_CACHE_MODEL = "cacheModel";
    private static final String NODE_FLUSH_INTERVAL = "flushInterval";
    private static final String NODE_FLUSH_ON_EXECUTE = "flushOnExecute";
    private static final String NODE_RESULT_MAP = "resultMap";
    private static final String NODE_PARAMETER_MAP = "parameterMap";
    private static final String NODE_SELECT = "select";
    private static final String NODE_INSERT = "insert";
    private static final String NODE_UPDATE = "update";
    private static final String NODE_DELETE = "delete";
    private static final String NODE_STATEMENT = "statement";
    private static final String NODE_PROCEDURE = "procedure";
    private static final String NODE_SELECT_KEY = "selectKey";
    private static final String NODE_TYPE_ALIAS = "typeAlias";
    private static final String KEY_CURRENT_NAMESPACE = "NAMESPACE";
    private static final String KEY_SQL_MAP_CLIENT = "SqlMapClient";
    private static final String KEY_GLOBAL_PROPS = "GlobalProperties";
    private static final String KEY_DATA_SOURCE = "DataSource";
    private static final String KEY_GLOBAL_SQL_MAP_CONV = "SqlMapConverter";
    private static final String KEY_GLOBAL_CONFIG_CONV = "SqlMapConfigConverter";
    private static final String KEY_ERROR_CONTEXT = "ErrorContext";
    private static final String KEY_ERROR_TRACING = "ErrorTracing";
    private static final String KEY_STATEMENT_NAMESPACES = "StatementNamespaces";
    private static final String GROUP_CACHE_MODEL = "CacheModel";
    private static final String GROUP_RESULT_MAP = "ResultMap";
    private static final String GROUP_PARAMETER_MAP = "ParameterMap";
    private static final String GROUP_SELECT_KEY = "SelectKey";
    private static final String PARAMETER_TOKEN = "#";
    private HashMap typeAliases = new HashMap();
    private Map contextPropertiesMap = new HashMap();
    private boolean validationEnabled = true;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$builder$xml$XmlSqlMapClientBuilder;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$transaction$jdbc$JdbcTransactionConfig;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$transaction$jta$JtaTransactionConfig;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$transaction$external$ExternalTransactionConfig;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$datasource$SimpleDataSourceFactory;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$datasource$DbcpDataSourceFactory;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$datasource$JndiDataSourceFactory;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$cache$fifo$FifoCacheController;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$cache$lru$LruCacheController;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$cache$memory$MemoryCacheController;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$XmlTypeMarker;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Iterator;

    public XmlSqlMapClientBuilder() {
        this.putTypeAlias("JDBC", (class$com$ibatis$sqlmap$engine$transaction$jdbc$JdbcTransactionConfig == null ? (class$com$ibatis$sqlmap$engine$transaction$jdbc$JdbcTransactionConfig = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.transaction.jdbc.JdbcTransactionConfig")) : class$com$ibatis$sqlmap$engine$transaction$jdbc$JdbcTransactionConfig).getName());
        this.putTypeAlias("JTA", (class$com$ibatis$sqlmap$engine$transaction$jta$JtaTransactionConfig == null ? (class$com$ibatis$sqlmap$engine$transaction$jta$JtaTransactionConfig = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.transaction.jta.JtaTransactionConfig")) : class$com$ibatis$sqlmap$engine$transaction$jta$JtaTransactionConfig).getName());
        this.putTypeAlias("EXTERNAL", (class$com$ibatis$sqlmap$engine$transaction$external$ExternalTransactionConfig == null ? (class$com$ibatis$sqlmap$engine$transaction$external$ExternalTransactionConfig = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.transaction.external.ExternalTransactionConfig")) : class$com$ibatis$sqlmap$engine$transaction$external$ExternalTransactionConfig).getName());
        this.putTypeAlias("SIMPLE", (class$com$ibatis$sqlmap$engine$datasource$SimpleDataSourceFactory == null ? (class$com$ibatis$sqlmap$engine$datasource$SimpleDataSourceFactory = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.datasource.SimpleDataSourceFactory")) : class$com$ibatis$sqlmap$engine$datasource$SimpleDataSourceFactory).getName());
        this.putTypeAlias("DBCP", (class$com$ibatis$sqlmap$engine$datasource$DbcpDataSourceFactory == null ? (class$com$ibatis$sqlmap$engine$datasource$DbcpDataSourceFactory = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.datasource.DbcpDataSourceFactory")) : class$com$ibatis$sqlmap$engine$datasource$DbcpDataSourceFactory).getName());
        this.putTypeAlias("JNDI", (class$com$ibatis$sqlmap$engine$datasource$JndiDataSourceFactory == null ? (class$com$ibatis$sqlmap$engine$datasource$JndiDataSourceFactory = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.datasource.JndiDataSourceFactory")) : class$com$ibatis$sqlmap$engine$datasource$JndiDataSourceFactory).getName());
        this.putTypeAlias("FIFO", (class$com$ibatis$sqlmap$engine$cache$fifo$FifoCacheController == null ? (class$com$ibatis$sqlmap$engine$cache$fifo$FifoCacheController = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.cache.fifo.FifoCacheController")) : class$com$ibatis$sqlmap$engine$cache$fifo$FifoCacheController).getName());
        this.putTypeAlias("LRU", (class$com$ibatis$sqlmap$engine$cache$lru$LruCacheController == null ? (class$com$ibatis$sqlmap$engine$cache$lru$LruCacheController = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.cache.lru.LruCacheController")) : class$com$ibatis$sqlmap$engine$cache$lru$LruCacheController).getName());
        this.putTypeAlias("MEMORY", (class$com$ibatis$sqlmap$engine$cache$memory$MemoryCacheController == null ? (class$com$ibatis$sqlmap$engine$cache$memory$MemoryCacheController = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.cache.memory.MemoryCacheController")) : class$com$ibatis$sqlmap$engine$cache$memory$MemoryCacheController).getName());
        this.putTypeAlias("OSCACHE", "com.ibatis.sqlmap.engine.cache.oscache.OSCacheController");
        this.putTypeAlias("xml", (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker).getName());
        this.putTypeAlias("xmlCollection", (class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.type.XmlCollectionTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker).getName());
        this.putTypeAlias("string", (class$java$lang$String == null ? (class$java$lang$String = XmlSqlMapClientBuilder.class$("java.lang.String")) : class$java$lang$String).getName());
        this.putTypeAlias("byte", (class$java$lang$Byte == null ? (class$java$lang$Byte = XmlSqlMapClientBuilder.class$("java.lang.Byte")) : class$java$lang$Byte).getName());
        this.putTypeAlias("long", (class$java$lang$Long == null ? (class$java$lang$Long = XmlSqlMapClientBuilder.class$("java.lang.Long")) : class$java$lang$Long).getName());
        this.putTypeAlias("short", (class$java$lang$Short == null ? (class$java$lang$Short = XmlSqlMapClientBuilder.class$("java.lang.Short")) : class$java$lang$Short).getName());
        this.putTypeAlias("int", (class$java$lang$Integer == null ? (class$java$lang$Integer = XmlSqlMapClientBuilder.class$("java.lang.Integer")) : class$java$lang$Integer).getName());
        this.putTypeAlias("integer", (class$java$lang$Integer == null ? (class$java$lang$Integer = XmlSqlMapClientBuilder.class$("java.lang.Integer")) : class$java$lang$Integer).getName());
        this.putTypeAlias("double", (class$java$lang$Double == null ? (class$java$lang$Double = XmlSqlMapClientBuilder.class$("java.lang.Double")) : class$java$lang$Double).getName());
        this.putTypeAlias("float", (class$java$lang$Float == null ? (class$java$lang$Float = XmlSqlMapClientBuilder.class$("java.lang.Float")) : class$java$lang$Float).getName());
        this.putTypeAlias("boolean", (class$java$lang$Boolean == null ? (class$java$lang$Boolean = XmlSqlMapClientBuilder.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName());
        this.putTypeAlias("date", (class$java$util$Date == null ? (class$java$util$Date = XmlSqlMapClientBuilder.class$("java.util.Date")) : class$java$util$Date).getName());
        this.putTypeAlias("decimal", (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = XmlSqlMapClientBuilder.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName());
        this.putTypeAlias("object", (class$java$lang$Object == null ? (class$java$lang$Object = XmlSqlMapClientBuilder.class$("java.lang.Object")) : class$java$lang$Object).getName());
        this.putTypeAlias("map", (class$java$util$Map == null ? (class$java$util$Map = XmlSqlMapClientBuilder.class$("java.util.Map")) : class$java$util$Map).getName());
        this.putTypeAlias("hashmap", (class$java$util$HashMap == null ? (class$java$util$HashMap = XmlSqlMapClientBuilder.class$("java.util.HashMap")) : class$java$util$HashMap).getName());
        this.putTypeAlias("list", (class$java$util$List == null ? (class$java$util$List = XmlSqlMapClientBuilder.class$("java.util.List")) : class$java$util$List).getName());
        this.putTypeAlias("arraylist", (class$java$util$ArrayList == null ? (class$java$util$ArrayList = XmlSqlMapClientBuilder.class$("java.util.ArrayList")) : class$java$util$ArrayList).getName());
        this.putTypeAlias("collection", (class$java$util$Collection == null ? (class$java$util$Collection = XmlSqlMapClientBuilder.class$("java.util.Collection")) : class$java$util$Collection).getName());
        this.putTypeAlias("iterator", (class$java$util$Iterator == null ? (class$java$util$Iterator = XmlSqlMapClientBuilder.class$("java.util.Iterator")) : class$java$util$Iterator).getName());
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public SqlMapClient buildSqlMap(Reader reader, Properties props, XmlConverter sqlMapConfigConverter, XmlConverter sqlMapConverter) {
        this.setContextObject(KEY_GLOBAL_PROPS, props);
        this.setContextObject(KEY_GLOBAL_SQL_MAP_CONV, sqlMapConverter);
        this.setContextObject(KEY_GLOBAL_CONFIG_CONV, sqlMapConfigConverter);
        return this.buildSqlMap(reader);
    }

    public SqlMapClient buildSqlMap(Reader reader, XmlConverter sqlMapConfigConverter, XmlConverter sqlMapConverter) {
        this.setContextObject(KEY_GLOBAL_SQL_MAP_CONV, sqlMapConverter);
        this.setContextObject(KEY_GLOBAL_CONFIG_CONV, sqlMapConfigConverter);
        return this.buildSqlMap(reader);
    }

    public SqlMapClient buildSqlMap(Reader reader, Properties props) {
        this.setContextObject(KEY_GLOBAL_PROPS, props);
        return this.buildSqlMap(reader);
    }

    public SqlMapClient buildSqlMap(Reader reader) {
        ErrorContext errorCtx = new ErrorContext();
        this.setContextObject(KEY_ERROR_CONTEXT, errorCtx);
        this.setContextObject(KEY_ERROR_TRACING, new Boolean(true));
        errorCtx.setResource("the SQL Map Configuration file");
        if (reader == null) {
            throw new SqlMapException("The reader passed to SqlMapClientBuilder was null.");
        }
        try {
            XmlConverter converter = (XmlConverter)this.getContextObject(KEY_GLOBAL_CONFIG_CONV);
            if (converter != null) {
                reader = converter.convertXml(reader);
            }
            Document doc = this.getDoc(reader);
            Element rootElement = (Element)doc.getLastChild();
            return this.parseSqlMapConfig(rootElement);
        }
        catch (Exception e) {
            errorCtx.setCause(e);
            throw new SqlMapException("There was an error while building the SqlMap instance." + errorCtx, e);
        }
    }

    private SqlMapClient parseSqlMapConfig(Node n) throws IOException {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("creating the SqlMapClient instance");
        SqlMapExecutorDelegate clientImpl = new SqlMapExecutorDelegate();
        this.setContextObject(KEY_SQL_MAP_CLIENT, new SqlMapClientImpl(clientImpl));
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (NODE_PROPERTIES.equals(child.getNodeName())) {
                    this.parseGlobalProperties(child);
                } else if (NODE_TYPE_ALIAS.equals(child.getNodeName())) {
                    this.parseTypeAliasNode(child);
                } else if (NODE_SETTINGS.equals(child.getNodeName())) {
                    this.parseSettings(child);
                } else if (NODE_TX_MANAGER.equals(child.getNodeName())) {
                    this.parseTransactionManager(child);
                } else if (NODE_SQL_MAP.equals(child.getNodeName())) {
                    this.parseSqlMapRef(child);
                }
            }
            ++i;
        }
        this.wireUpCacheModelListeners();
        return new SqlMapClientImpl(clientImpl);
    }

    private void parseGlobalProperties(Node n) {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("loading global properties");
        Properties attributes = this.parseAttributes(n);
        String resource = attributes.getProperty("resource");
        String url = attributes.getProperty("url");
        try {
            Properties props = null;
            if (resource != null) {
                errorCtx.setResource(resource);
                props = Resources.getResourceAsProperties((String)resource);
            } else if (url != null) {
                errorCtx.setResource(url);
                props = Resources.getUrlAsProperties((String)resource);
            } else {
                throw new SqlMapException("The properties element requires either a resource or a url attribute.");
            }
            Properties existingProperties = (Properties)this.getContextObject(KEY_GLOBAL_PROPS);
            if (existingProperties == null) {
                this.setContextObject(KEY_GLOBAL_PROPS, props);
            } else {
                props.putAll((Map<?, ?>)existingProperties);
                this.setContextObject(KEY_GLOBAL_PROPS, props);
            }
        }
        catch (IOException e) {
            throw new SqlMapException("Error loading properties.  Cause: " + e);
        }
    }

    private void parseSettings(Node n) {
        String maxSessions;
        String maxRequests;
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("loading settings properties");
        ExtendedSqlMapClient client = (ExtendedSqlMapClient)this.getContextObject(KEY_SQL_MAP_CLIENT);
        Properties attributes = this.parseAttributes(n);
        String lazyLoadingEnabledAttr = attributes.getProperty("lazyLoadingEnabled");
        boolean lazyLoadingEnabled = lazyLoadingEnabledAttr == null || "true".equals(lazyLoadingEnabledAttr);
        client.getDelegate().setLazyLoadingEnabled(lazyLoadingEnabled);
        String cacheModelsEnabledAttr = attributes.getProperty("cacheModelsEnabled");
        boolean cacheModelsEnabled = cacheModelsEnabledAttr == null || "true".equals(cacheModelsEnabledAttr);
        client.getDelegate().setCacheModelsEnabled(cacheModelsEnabled);
        String enhancementEnabledAttr = attributes.getProperty("enhancementEnabled");
        boolean enhancementEnabled = enhancementEnabledAttr == null || "true".equals(enhancementEnabledAttr);
        try {
            enhancementEnabled = enhancementEnabled && Class.forName("net.sf.cglib.proxy.InvocationHandler") != null;
        }
        catch (ClassNotFoundException e) {
            enhancementEnabled = false;
        }
        client.getDelegate().setEnhancementEnabled(enhancementEnabled);
        String useStatementNamespacesAttr = attributes.getProperty("useStatementNamespaces");
        boolean useStatementNamespaces = "true".equals(useStatementNamespacesAttr);
        this.setContextObject(KEY_STATEMENT_NAMESPACES, new Boolean(useStatementNamespaces));
        String errorTracingEnabledAttr = attributes.getProperty("errorTracingEnabled");
        boolean errorTracingEnabled = errorTracingEnabledAttr == null || "true".equals(errorTracingEnabledAttr);
        this.setContextObject(KEY_ERROR_TRACING, new Boolean(errorTracingEnabled));
        String maxTransactions = attributes.getProperty("maxTransactions");
        if (maxTransactions != null && Integer.parseInt(maxTransactions) > 0) {
            client.getDelegate().setMaxTransactions(Integer.parseInt(maxTransactions));
        }
        if ((maxRequests = attributes.getProperty("maxRequests")) != null && Integer.parseInt(maxRequests) > 0) {
            client.getDelegate().setMaxRequests(Integer.parseInt(maxRequests));
        }
        if ((maxSessions = attributes.getProperty("maxSessions")) != null && Integer.parseInt(maxSessions) > 0) {
            client.getDelegate().setMaxSessions(Integer.parseInt(maxSessions));
        }
        AccessPlanFactory.setBytecodeEnhancementEnabled(client.getDelegate().isEnhancementEnabled());
    }

    private void parseTransactionManager(Node n) {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("configuring the transaction manager");
        ExtendedSqlMapClient client = (ExtendedSqlMapClient)this.getContextObject(KEY_SQL_MAP_CLIENT);
        Properties attributes = this.parseAttributes(n);
        Properties initProperties = new Properties();
        String type = attributes.getProperty("type");
        type = this.resolveAlias(type);
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (NODE_PROPERTY.equals(child.getNodeName())) {
                    this.addNameValuePairProperty(child, initProperties);
                } else if (NODE_DATA_SOURCE.equals(child.getNodeName())) {
                    this.parseDataSource(child);
                }
            }
            ++i;
        }
        TransactionManager txManager = null;
        try {
            DataSource dataSource = (DataSource)this.getContextObject(KEY_DATA_SOURCE);
            errorCtx.setMoreInfo("Check the transaction manager type or class.");
            TransactionConfig config = (TransactionConfig)Resources.instantiate((String)type);
            config.setDataSource(dataSource);
            config.setMaximumConcurrentTransactions(client.getDelegate().getMaxTransactions());
            errorCtx.setMoreInfo("Check the transactio nmanager properties or configuration.");
            config.initialize(initProperties);
            errorCtx.setMoreInfo(null);
            txManager = new TransactionManager(config);
        }
        catch (Exception e) {
            if (e instanceof SqlMapException) {
                throw (SqlMapException)((Object)e);
            }
            throw new SqlMapException("Error initializing TransactionManager.  Could not instantiate TransactionConfig.  Cause: " + e, e);
        }
        client.getDelegate().setTxManager(txManager);
    }

    private void parseDataSource(Node n) {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("configuring the data source");
        Properties attributes = this.parseAttributes(n);
        Properties initProperties = new Properties();
        String type = attributes.getProperty("type");
        type = this.resolveAlias(type);
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && NODE_PROPERTY.equals(child.getNodeName())) {
                this.addNameValuePairProperty(child, initProperties);
            }
            ++i;
        }
        DataSource dataSource = null;
        try {
            errorCtx.setMoreInfo("Check the data source type or class.");
            DataSourceFactory dsFactory = (DataSourceFactory)Resources.instantiate((String)type);
            errorCtx.setMoreInfo("Check the data source properties or configuration.");
            dsFactory.initialize(initProperties);
            dataSource = dsFactory.getDataSource();
            errorCtx.setMoreInfo(null);
        }
        catch (Exception e) {
            if (e instanceof SqlMapException) {
                throw (SqlMapException)((Object)e);
            }
            throw new SqlMapException("Error initializing DataSource.  Could not instantiate DataSourceFactory.  Cause: " + e, e);
        }
        this.setContextObject(KEY_DATA_SOURCE, dataSource);
    }

    private void parseSqlMapRef(Node n) throws IOException {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("loading the SQL Map resource");
        Properties attributes = this.parseAttributes(n);
        String resource = attributes.getProperty("resource");
        String url = attributes.getProperty("url");
        Reader reader = null;
        if (resource != null) {
            errorCtx.setResource(resource);
            reader = Resources.getResourceAsReader((String)resource);
        } else if (url != null) {
            errorCtx.setResource(url);
            reader = Resources.getUrlAsReader((String)url);
        } else {
            throw new SqlMapException("The sqlMap element requires either a resource or a url attribute.");
        }
        XmlConverter converter = (XmlConverter)this.getContextObject(KEY_GLOBAL_SQL_MAP_CONV);
        if (converter != null) {
            reader = converter.convertXml(reader);
        }
        Document doc = this.getDoc(reader);
        this.parseSqlMap(doc.getLastChild());
        reader.close();
    }

    private void parseSqlMap(Node n) {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("building an SQL Map instance");
        Properties attributes = this.parseAttributes(n);
        String namespace = attributes.getProperty("namespace");
        this.setContextObject(KEY_CURRENT_NAMESPACE, namespace);
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (NODE_SELECT.equals(child.getNodeName())) {
                    this.parseSelect(child);
                } else if (NODE_INSERT.equals(child.getNodeName())) {
                    this.parseInsert(child);
                } else if (NODE_UPDATE.equals(child.getNodeName())) {
                    this.parseUpdate(child);
                } else if (NODE_DELETE.equals(child.getNodeName())) {
                    this.parseDelete(child);
                } else if (NODE_STATEMENT.equals(child.getNodeName())) {
                    this.parseStatement(child);
                } else if (NODE_PROCEDURE.equals(child.getNodeName())) {
                    this.parseProcedure(child);
                } else if (NODE_RESULT_MAP.equals(child.getNodeName())) {
                    this.parseResultMap(child);
                } else if (NODE_PARAMETER_MAP.equals(child.getNodeName())) {
                    this.parseParameterMap(child);
                } else if (NODE_CACHE_MODEL.equals(child.getNodeName())) {
                    this.parseCacheModel(child);
                } else if (NODE_TYPE_ALIAS.equals(child.getNodeName())) {
                    this.parseTypeAliasNode(child);
                }
            }
            ++i;
        }
    }

    private void parseProcedure(Node n) {
        ExtendedSqlMapClient client = (ExtendedSqlMapClient)this.getContextObject(KEY_SQL_MAP_CLIENT);
        ProcedureStatement statement = (ProcedureStatement)this.parseGeneralStatement(n, new ProcedureStatement());
        client.getDelegate().addMappedStatement(statement);
    }

    private void parseSelect(Node n) {
        ExtendedSqlMapClient client = (ExtendedSqlMapClient)this.getContextObject(KEY_SQL_MAP_CLIENT);
        SelectStatement statement = (SelectStatement)this.parseGeneralStatement(n, new SelectStatement());
        client.getDelegate().addMappedStatement(statement);
    }

    private void parseInsert(Node n) {
        ExtendedSqlMapClient client = (ExtendedSqlMapClient)this.getContextObject(KEY_SQL_MAP_CLIENT);
        InsertStatement statement = (InsertStatement)this.parseGeneralStatement(n, new InsertStatement());
        client.getDelegate().addMappedStatement(statement);
    }

    private void parseUpdate(Node n) {
        ExtendedSqlMapClient client = (ExtendedSqlMapClient)this.getContextObject(KEY_SQL_MAP_CLIENT);
        UpdateStatement statement = (UpdateStatement)this.parseGeneralStatement(n, new UpdateStatement());
        client.getDelegate().addMappedStatement(statement);
    }

    private void parseDelete(Node n) {
        ExtendedSqlMapClient client = (ExtendedSqlMapClient)this.getContextObject(KEY_SQL_MAP_CLIENT);
        DeleteStatement statement = (DeleteStatement)this.parseGeneralStatement(n, new DeleteStatement());
        client.getDelegate().addMappedStatement(statement);
    }

    private void parseStatement(Node n) {
        ExtendedSqlMapClient client = (ExtendedSqlMapClient)this.getContextObject(KEY_SQL_MAP_CLIENT);
        MappedStatement statement = this.parseGeneralStatement(n, new GeneralStatement());
        client.getDelegate().addMappedStatement(statement);
    }

    /*
     * Unable to fully structure code
     */
    private MappedStatement parseGeneralStatement(Node n, GeneralStatement statement) {
        errorCtx = (ErrorContext)this.getContextObject("ErrorContext");
        errorCtx.setActivity("parsing a mapped statement");
        attributes = this.parseAttributes(n);
        id = attributes.getProperty("id");
        if (this.isStatementNamespacesEnabled()) {
            id = this.applyNamespace(id);
        }
        parameterMapName = this.applyNamespace(attributes.getProperty("parameterMap"));
        parameterClassName = attributes.getProperty("parameterClass");
        resultMapName = this.applyNamespace(attributes.getProperty("resultMap"));
        resultClassName = attributes.getProperty("resultClass");
        cacheModelName = this.applyNamespace(attributes.getProperty("cacheModel"));
        xmlResultName = attributes.getProperty("xmlResultName");
        errorCtx.setObjectId(id + " statement");
        parameterClassName = this.resolveAlias(parameterClassName);
        resultClassName = this.resolveAlias(resultClassName);
        parameterClass = null;
        resultClass = null;
        errorCtx.setMoreInfo("Check the result map name.");
        resultMap = (BasicResultMap)this.getSubContextObject("ResultMap", resultMapName);
        if (resultMap == null && resultMapName != null) {
            throw new SqlMapException("Could not find ResultMap named " + resultMapName);
        }
        errorCtx.setMoreInfo("Check the parameter map name.");
        parameterMap = (BasicParameterMap)this.getSubContextObject("ParameterMap", parameterMapName);
        if (parameterMap == null && parameterMapName != null) {
            throw new SqlMapException("Could not find ParameterMap named " + parameterMapName);
        }
        statement.setId(id);
        statement.setParameterMap(parameterMap);
        statement.setResultMap(resultMap);
        statement.setResource(errorCtx.getResource());
        if (parameterMap == null) {
            try {
                if (parameterClassName == null) ** GOTO lbl40
                errorCtx.setMoreInfo("Check the parameter class.");
                parameterClass = Resources.classForName((String)parameterClassName);
                statement.setParameterClass(parameterClass);
            }
            catch (ClassNotFoundException e) {
                throw new SqlMapException("Error.  Could not set parameter class.  Cause: " + e, e);
            }
        } else {
            statement.setParameterClass(parameterMap.getParameterClass());
        }
lbl40:
        // 3 sources

        try {
            if (resultClassName != null) {
                errorCtx.setMoreInfo("Check the result class.");
                resultClass = Resources.classForName((String)resultClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SqlMapException("Error.  Could not set result class.  Cause: " + e, e);
        }
        errorCtx.setMoreInfo("Check the SQL statement.");
        this.processSqlStatement(n, statement);
        if (resultMap == null && resultClass == null) {
            statement.setResultMap(null);
        } else if (resultMap == null) {
            resultMap = new AutoResultMap();
            resultMap.setId(statement.getId() + "-AutoResultMap");
            resultMap.setResultClass(resultClass);
            resultMap.setXmlName(xmlResultName);
            resultMap.setResource(statement.getResource());
            statement.setResultMap(resultMap);
        }
        errorCtx.setMoreInfo(null);
        errorCtx.setObjectId(null);
        client = (ExtendedSqlMapClient)this.getContextObject("SqlMapClient");
        statement.setSqlMapClient(client);
        if (cacheModelName != null && cacheModelName.length() > 0 && client.getDelegate().isCacheModelsEnabled()) {
            cacheModel = (CacheModel)this.getSubContextObject("CacheModel", cacheModelName);
            return new CachingStatement(statement, cacheModel);
        }
        return statement;
    }

    private SelectKeyStatement parseSelectKey(Node n, GeneralStatement insertStatement) {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("parsing a select key");
        Properties attributes = this.parseAttributes(n);
        String keyPropName = attributes.getProperty("keyProperty");
        String resultClassName = attributes.getProperty("resultClass");
        resultClassName = this.resolveAlias(resultClassName);
        Class resultClass = null;
        SelectKeyStatement selectKeyStatement = new SelectKeyStatement();
        ExtendedSqlMapClient client = (ExtendedSqlMapClient)this.getContextObject(KEY_SQL_MAP_CLIENT);
        selectKeyStatement.setSqlMapClient(client);
        selectKeyStatement.setId(insertStatement.getId() + GROUP_SELECT_KEY);
        selectKeyStatement.setResource(errorCtx.getResource());
        selectKeyStatement.setKeyProperty(keyPropName);
        try {
            if (resultClassName != null) {
                errorCtx.setMoreInfo("Check the select key result class.");
                resultClass = Resources.classForName((String)resultClassName);
            } else {
                Class parameterClass = insertStatement.getParameterClass();
                if (keyPropName != null && parameterClass != null) {
                    resultClass = BeanProbe.getPropertyTypeForSetter((Class)parameterClass, (String)selectKeyStatement.getKeyProperty());
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new SqlMapException("Error.  Could not set result class.  Cause: " + e, e);
        }
        if (resultClass == null) {
            resultClass = class$java$lang$Object == null ? (class$java$lang$Object = XmlSqlMapClientBuilder.class$("java.lang.Object")) : class$java$lang$Object;
        }
        errorCtx.setMoreInfo("Check the select key SQL statement.");
        this.processSqlStatement(n, selectKeyStatement);
        AutoResultMap resultMap = new AutoResultMap();
        resultMap.setId(selectKeyStatement.getId() + "-AutoResultMap");
        resultMap.setResultClass(resultClass);
        resultMap.setResource(selectKeyStatement.getResource());
        selectKeyStatement.setResultMap(resultMap);
        errorCtx.setMoreInfo(null);
        return selectKeyStatement;
    }

    private void processSqlStatement(Node n, GeneralStatement statement) {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("processing an SQL statement");
        boolean isDynamic = false;
        DynamicSql dynamic = new DynamicSql();
        StringBuffer sqlBuffer = new StringBuffer();
        isDynamic = this.parseDynamicTags(n, dynamic, sqlBuffer, isDynamic, false);
        if (statement instanceof InsertStatement) {
            InsertStatement insertStatement = (InsertStatement)statement;
            SelectKeyStatement selectKeyStatement = this.findAndParseSelectKeyStatement(n, statement);
            insertStatement.setSelectKeyStatement(selectKeyStatement);
        }
        String sqlStatement = sqlBuffer.toString();
        if (isDynamic) {
            statement.setSql(dynamic);
        } else {
            this.applyInlineParameterMap(statement, sqlStatement);
        }
    }

    private boolean parseDynamicTags(Node n, DynamicParent dynamic, StringBuffer sqlBuffer, boolean isDynamic, boolean postParseRequired) {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("parsing dynamic SQL tags");
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 4 || child.getNodeType() == 3) {
                SqlText sqlText;
                String data = ((CharacterData)child).getData();
                data = this.parsePropertyTokens(data);
                if (postParseRequired) {
                    sqlText = new SqlText();
                    sqlText.setText(data.toString());
                } else {
                    sqlText = XmlSqlMapClientBuilder.parseInlineParameterMap(data.toString());
                }
                dynamic.addChild(sqlText);
                sqlBuffer.append(data);
            } else {
                errorCtx.setMoreInfo("Check the dynamic tags.");
                String nodeName = child.getNodeName();
                SqlTagHandler handler = SqlTagHandlerFactory.getSqlTagHandler(nodeName);
                if (handler != null) {
                    isDynamic = true;
                    SqlTag tag = new SqlTag();
                    tag.setName(nodeName);
                    tag.setHandler(handler);
                    Properties attributes = this.parseAttributes(child);
                    tag.setPrependAttr(attributes.getProperty("prepend"));
                    tag.setPropertyAttr(attributes.getProperty(NODE_PROPERTY));
                    tag.setOpenAttr(attributes.getProperty("open"));
                    tag.setCloseAttr(attributes.getProperty("close"));
                    tag.setComparePropertyAttr(attributes.getProperty("compareProperty"));
                    tag.setCompareValueAttr(attributes.getProperty("compareValue"));
                    tag.setConjunctionAttr(attributes.getProperty("conjunction"));
                    dynamic.addChild(tag);
                    if (child.hasChildNodes()) {
                        isDynamic = this.parseDynamicTags(child, tag, sqlBuffer, isDynamic, handler.isPostParseRequired());
                    }
                }
            }
            ++i;
        }
        errorCtx.setMoreInfo(null);
        return isDynamic;
    }

    private SelectKeyStatement findAndParseSelectKeyStatement(Node n, GeneralStatement insertStatement) {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("parsing select key tags");
        SelectKeyStatement selectKeyStatement = null;
        boolean foundTextFirst = false;
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 4 || child.getNodeType() == 3) {
                String data = ((CharacterData)child).getData();
                if (data.trim().length() > 0) {
                    foundTextFirst = true;
                }
            } else if (child.getNodeType() == 1 && NODE_SELECT_KEY.equals(child.getNodeName())) {
                selectKeyStatement = this.parseSelectKey(child, insertStatement);
                break;
            }
            ++i;
        }
        if (selectKeyStatement != null) {
            selectKeyStatement.setAfter(foundTextFirst);
        }
        errorCtx.setMoreInfo(null);
        return selectKeyStatement;
    }

    private void applyInlineParameterMap(GeneralStatement statement, String sqlStatement) {
        String newSql = sqlStatement;
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("building an inline parameter map");
        ParameterMap parameterMap = statement.getParameterMap();
        errorCtx.setMoreInfo("Check the inline parameters.");
        if (parameterMap == null) {
            BasicParameterMap map = new BasicParameterMap();
            map.setId(statement.getId() + "-InlineParameterMap");
            map.setParameterClass(statement.getParameterClass());
            map.setResource(statement.getResource());
            statement.setParameterMap(map);
            SqlText sqlText = XmlSqlMapClientBuilder.parseInlineParameterMap(statement.getParameterClass(), newSql);
            newSql = sqlText.getText();
            List<ParameterMapping> mappingList = Arrays.asList(sqlText.getParameterMappings());
            map.setParameterMappingList(mappingList);
        }
        Sql sql = null;
        sql = SimpleDynamicSql.isSimpleDynamicSql(newSql) ? new SimpleDynamicSql(newSql) : new StaticSql(newSql);
        statement.setSql(sql);
    }

    public static SqlText parseInlineParameterMap(String sqlStatement) {
        return XmlSqlMapClientBuilder.parseInlineParameterMap(null, sqlStatement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SqlText parseInlineParameterMap(Class parameterClass, String sqlStatement) {
        String newSql = sqlStatement;
        ArrayList<BasicParameterMapping> mappingList = new ArrayList<BasicParameterMapping>();
        StringTokenizer parser = new StringTokenizer(sqlStatement, PARAMETER_TOKEN, true);
        StringBuffer newSqlBuffer = new StringBuffer();
        String token = null;
        String lastToken = null;
        while (parser.hasMoreTokens()) {
            token = parser.nextToken();
            if (PARAMETER_TOKEN.equals(lastToken)) {
                if (PARAMETER_TOKEN.equals(token)) {
                    newSqlBuffer.append(PARAMETER_TOKEN);
                    token = null;
                } else {
                    if (token.indexOf(58) > -1) {
                        String type;
                        String name;
                        StringTokenizer paramParser = new StringTokenizer(token, ":", true);
                        int n1 = paramParser.countTokens();
                        if (n1 == 3) {
                            name = paramParser.nextToken();
                            paramParser.nextToken();
                            type = paramParser.nextToken();
                            BasicParameterMapping mapping = new BasicParameterMapping();
                            mapping.setPropertyName(name);
                            mapping.setJdbcTypeName(type);
                            TypeHandler handler = parameterClass == null ? TypeHandlerFactory.getUnkownTypeHandler() : XmlSqlMapClientBuilder.resolveTypeHandler(parameterClass, name, null);
                            mapping.setTypeHandler(handler);
                            mappingList.add(mapping);
                        } else {
                            if (n1 < 5) throw new SqlMapException("Incorrect inline parameter map format: " + token);
                            name = paramParser.nextToken();
                            paramParser.nextToken();
                            type = paramParser.nextToken();
                            paramParser.nextToken();
                            String nullValue = paramParser.nextToken();
                            while (paramParser.hasMoreTokens()) {
                                nullValue = nullValue + paramParser.nextToken();
                            }
                            BasicParameterMapping mapping = new BasicParameterMapping();
                            mapping.setPropertyName(name);
                            mapping.setJdbcTypeName(type);
                            mapping.setNullValue(nullValue);
                            TypeHandler handler = parameterClass == null ? TypeHandlerFactory.getUnkownTypeHandler() : XmlSqlMapClientBuilder.resolveTypeHandler(parameterClass, name, null);
                            mapping.setTypeHandler(handler);
                            mappingList.add(mapping);
                        }
                    } else {
                        BasicParameterMapping mapping = new BasicParameterMapping();
                        mapping.setPropertyName(token);
                        TypeHandler handler = parameterClass == null ? TypeHandlerFactory.getUnkownTypeHandler() : XmlSqlMapClientBuilder.resolveTypeHandler(parameterClass, token, null);
                        mapping.setTypeHandler(handler);
                        mappingList.add(mapping);
                    }
                    newSqlBuffer.append("?");
                    token = parser.nextToken();
                    if (!PARAMETER_TOKEN.equals(token)) {
                        throw new SqlMapException("Unterminated inline parameter in mapped statement (statement.getId()).");
                    }
                    token = null;
                }
            } else if (!PARAMETER_TOKEN.equals(token)) {
                newSqlBuffer.append(token);
            }
            lastToken = token;
        }
        newSql = newSqlBuffer.toString();
        ParameterMapping[] mappingArray = mappingList.toArray(new ParameterMapping[mappingList.size()]);
        SqlText sqlText = new SqlText();
        sqlText.setText(newSql);
        sqlText.setParameterMappings(mappingArray);
        return sqlText;
    }

    private void parseResultMap(Node n) {
        int i;
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("building a result map");
        BasicResultMap map = new BasicResultMap();
        Properties attributes = this.parseAttributes(n);
        String id = this.applyNamespace(attributes.getProperty("id"));
        String resultClassName = attributes.getProperty("class");
        String extended = this.applyNamespace(attributes.getProperty("extends"));
        String xmlName = attributes.getProperty("xmlName");
        resultClassName = this.resolveAlias(resultClassName);
        errorCtx.setObjectId(id + " result map");
        map.setId(id);
        map.setXmlName(xmlName);
        map.setResource(errorCtx.getResource());
        Class resultClass = null;
        try {
            errorCtx.setMoreInfo("Check the result class.");
            resultClass = Resources.classForName((String)resultClassName);
        }
        catch (Exception e) {
            if (e instanceof SqlMapException) {
                throw (SqlMapException)((Object)e);
            }
            throw new SqlMapException("Error configuring Result.  Could not set ResultClass.  Cause: " + e, e);
        }
        map.setResultClass(resultClass);
        ArrayList<ResultMapping> resultMappingList = new ArrayList<ResultMapping>();
        errorCtx.setMoreInfo("Check the extended result map.");
        if (extended != null) {
            BasicResultMap extendedResultMap = (BasicResultMap)this.getSubContextObject(GROUP_RESULT_MAP, extended);
            ResultMapping[] resultMappings = extendedResultMap.getResultMappings();
            i = 0;
            while (i < resultMappings.length) {
                resultMappingList.add(resultMappings[i]);
                ++i;
            }
        }
        errorCtx.setMoreInfo("Check the result mappings.");
        NodeList children = n.getChildNodes();
        int index = resultMappingList.size();
        i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Properties childAttributes = this.parseAttributes(child);
                String propertyName = childAttributes.getProperty(NODE_PROPERTY);
                String nullValue = childAttributes.getProperty("nullValue");
                String jdbcType = childAttributes.getProperty("jdbcType");
                String javaType = childAttributes.getProperty("javaType");
                String columnName = childAttributes.getProperty("column");
                String columnIndex = childAttributes.getProperty("columnIndex");
                String statementName = childAttributes.getProperty(NODE_SELECT);
                javaType = this.resolveAlias(javaType);
                errorCtx.setObjectId(propertyName + " mapping of the " + id + " result map");
                errorCtx.setMoreInfo("Check the result mapping property type or name.");
                TypeHandler handler = XmlSqlMapClientBuilder.resolveTypeHandler(resultClass, propertyName, javaType);
                BasicResultMapping mapping = new BasicResultMapping();
                mapping.setPropertyName(propertyName);
                mapping.setColumnName(columnName);
                mapping.setJdbcTypeName(jdbcType);
                mapping.setTypeHandler(handler);
                mapping.setNullValue(nullValue);
                mapping.setStatementName(statementName);
                try {
                    if (javaType != null && javaType.length() > 0) {
                        mapping.setJavaType(Class.forName(javaType));
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error setting javaType on result mapping.  Cause: " + e);
                }
                if (columnIndex != null && columnIndex.length() > 0) {
                    mapping.setColumnIndex(Integer.parseInt(columnIndex));
                } else {
                    mapping.setColumnIndex(++index);
                }
                resultMappingList.add(mapping);
            }
            ++i;
        }
        map.setResultMappingList(resultMappingList);
        this.setSubContextObject(GROUP_RESULT_MAP, map.getId(), map);
        errorCtx.setMoreInfo(null);
        errorCtx.setObjectId(null);
    }

    private void parseParameterMap(Node n) {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("building a parameter map");
        BasicParameterMap map = new BasicParameterMap();
        Properties attributes = this.parseAttributes(n);
        String id = this.applyNamespace(attributes.getProperty("id"));
        String parameterClassName = attributes.getProperty("class");
        parameterClassName = this.resolveAlias(parameterClassName);
        map.setId(id);
        map.setResource(errorCtx.getResource());
        errorCtx.setObjectId(id + " parameter map");
        Class parameterClass = null;
        try {
            errorCtx.setMoreInfo("Check the parameter class.");
            parameterClass = Resources.classForName((String)parameterClassName);
        }
        catch (Exception e) {
            // empty catch block
        }
        map.setParameterClass(parameterClass);
        ArrayList<BasicParameterMapping> parameterMappingList = new ArrayList<BasicParameterMapping>();
        errorCtx.setMoreInfo("Check the parameter mappings.");
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Properties childAttributes = this.parseAttributes(child);
                String propertyName = childAttributes.getProperty(NODE_PROPERTY);
                String jdbcType = childAttributes.getProperty("jdbcType");
                String javaType = childAttributes.getProperty("javaType");
                String nullValue = childAttributes.getProperty("nullValue");
                String mode = childAttributes.getProperty("mode");
                javaType = this.resolveAlias(javaType);
                errorCtx.setObjectId(propertyName + " mapping of the " + id + " parameter map");
                errorCtx.setMoreInfo("Check the parameter mapping property type or name.");
                TypeHandler handler = XmlSqlMapClientBuilder.resolveTypeHandler(parameterClass, propertyName, javaType);
                BasicParameterMapping mapping = new BasicParameterMapping();
                mapping.setPropertyName(propertyName);
                mapping.setJdbcTypeName(jdbcType);
                mapping.setNullValue(nullValue);
                if (mode != null && mode.length() > 0) {
                    mapping.setMode(mode);
                }
                mapping.setTypeHandler(handler);
                try {
                    if (javaType != null && javaType.length() > 0) {
                        mapping.setJavaType(Class.forName(javaType));
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error setting javaType on parameter mapping.  Cause: " + e);
                }
                parameterMappingList.add(mapping);
            }
            ++i;
        }
        map.setParameterMappingList(parameterMappingList);
        this.setSubContextObject(GROUP_PARAMETER_MAP, map.getId(), map);
        errorCtx.setMoreInfo(null);
        errorCtx.setObjectId(null);
    }

    private void parseCacheModel(Node n) {
        ErrorContext errorCtx = (ErrorContext)this.getContextObject(KEY_ERROR_CONTEXT);
        errorCtx.setActivity("building a cache model");
        CacheModel model = new CacheModel();
        Properties attributes = this.parseAttributes(n);
        String id = this.applyNamespace(attributes.getProperty("id"));
        String type = attributes.getProperty("type");
        type = this.resolveAlias(type);
        String readOnly = attributes.getProperty("readOnly");
        if (readOnly != null && readOnly.length() > 0) {
            model.setReadOnly("true".equals(readOnly));
        } else {
            model.setReadOnly(true);
        }
        errorCtx.setObjectId(id + " cache model");
        errorCtx.setMoreInfo("Check the cache model type.");
        model.setId(id);
        model.setResource(errorCtx.getResource());
        try {
            model.setControllerClassName(type);
        }
        catch (Exception e) {
            throw new SqlMapException("Error setting Cache Controller Class.  Cause: " + e, e);
        }
        Properties modelProperties = new Properties();
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Properties childAttributes;
                if (NODE_FLUSH_INTERVAL.equals(child.getNodeName())) {
                    childAttributes = this.parseAttributes(child);
                    long t = 0L;
                    try {
                        errorCtx.setMoreInfo("Check the cache model flush interval.");
                        String milliseconds = childAttributes.getProperty("milliseconds");
                        String seconds = childAttributes.getProperty("seconds");
                        String minutes = childAttributes.getProperty("minutes");
                        String hours = childAttributes.getProperty("hours");
                        if (milliseconds != null) {
                            t += (long)Integer.parseInt(milliseconds);
                        }
                        if (seconds != null) {
                            t += (long)(Integer.parseInt(seconds) * 1000);
                        }
                        if (minutes != null) {
                            t += (long)(Integer.parseInt(minutes) * 60 * 1000);
                        }
                        if (hours != null) {
                            t += (long)(Integer.parseInt(hours) * 60 * 60 * 1000);
                        }
                        if (t < 1L) {
                            throw new SqlMapException("A flush interval must specify one or more of milliseconds, seconds, minutes or hours.");
                        }
                        model.setFlushInterval(t);
                    }
                    catch (NumberFormatException e) {
                        throw new SqlMapException("Error building cache '" + model.getId() + "' in '" + "resourceNAME" + "'.  Flush interval milliseconds must be a valid long integer value.  Cause: " + e, e);
                    }
                } else if (NODE_FLUSH_ON_EXECUTE.equals(child.getNodeName())) {
                    errorCtx.setMoreInfo("Check the cache model flush on statement elements.");
                    childAttributes = this.parseAttributes(child);
                    model.addFlushTriggerStatement(childAttributes.getProperty(NODE_STATEMENT));
                } else if (NODE_PROPERTY.equals(child.getNodeName())) {
                    errorCtx.setMoreInfo("Check the cache model properties.");
                    this.addNameValuePairProperty(child, modelProperties);
                }
            }
            ++i;
        }
        errorCtx.setMoreInfo("Check the cache model configuration.");
        model.configure(modelProperties);
        ExtendedSqlMapClient client = (ExtendedSqlMapClient)this.getContextObject(KEY_SQL_MAP_CLIENT);
        if (client.getDelegate().isCacheModelsEnabled()) {
            this.setSubContextObject(GROUP_CACHE_MODEL, model.getId(), model);
        }
        errorCtx.setMoreInfo(null);
        errorCtx.setObjectId(null);
    }

    private String applyNamespace(String id) {
        String newId = id;
        String namespace = (String)this.getContextObject(KEY_CURRENT_NAMESPACE);
        if (namespace != null && namespace.length() > 0 && id != null && id.indexOf(".") < 0) {
            newId = namespace + "." + id;
        }
        return newId;
    }

    private void wireUpCacheModelListeners() {
        ExtendedSqlMapClient client = (ExtendedSqlMapClient)this.getContextObject(KEY_SQL_MAP_CLIENT);
        Map cacheModelMap = (Map)this.getContextObject(GROUP_CACHE_MODEL);
        if (cacheModelMap != null) {
            Iterator cacheNames = cacheModelMap.keySet().iterator();
            while (cacheNames.hasNext()) {
                String cacheName = (String)cacheNames.next();
                CacheModel cacheModel = (CacheModel)cacheModelMap.get(cacheName);
                Iterator statementNames = cacheModel.getFlushTriggerStatementNames();
                while (statementNames.hasNext()) {
                    String statementName = (String)statementNames.next();
                    MappedStatement statement = client.getDelegate().getMappedStatement(statementName);
                    if (statement != null) {
                        statement.addExecuteListener(cacheModel);
                        continue;
                    }
                    throw new SqlMapException("Could not find statement named '" + statementName + "' for use as a flush trigger for the cache model named '" + cacheName + "'.");
                }
            }
        }
    }

    private Document getDoc(Reader reader) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            dbf.setValidating(this.validationEnabled);
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setCoalescing(false);
            dbf.setExpandEntityReferences(false);
            OutputStreamWriter errorWriter = new OutputStreamWriter(System.err);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new SimpleErrorHandler(new PrintWriter((Writer)errorWriter, true)));
            db.setEntityResolver(new SqlMapClasspathEntityResolver());
            Document doc = db.parse((InputStream)new ReaderInputStream(reader));
            return doc;
        }
        catch (Exception e) {
            throw new SqlMapException("XML Parser Error.  Cause: " + e, e);
        }
    }

    private static TypeHandler resolveTypeHandler(Class clazz, String propertyName, String propertyType) {
        TypeHandler handler = null;
        if (clazz == null) {
            handler = TypeHandlerFactory.getUnkownTypeHandler();
        } else if ((class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker = XmlSqlMapClientBuilder.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker).isAssignableFrom(clazz)) {
            handler = TypeHandlerFactory.getTypeHandler(class$java$lang$String == null ? (class$java$lang$String = XmlSqlMapClientBuilder.class$("java.lang.String")) : class$java$lang$String);
        } else if ((class$java$util$Map == null ? (class$java$util$Map = XmlSqlMapClientBuilder.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
            if (propertyType == null) {
                handler = TypeHandlerFactory.getTypeHandler(class$java$lang$Object == null ? (class$java$lang$Object = XmlSqlMapClientBuilder.class$("java.lang.Object")) : class$java$lang$Object);
            } else {
                try {
                    Class javaClass = Resources.classForName((String)propertyType);
                    handler = TypeHandlerFactory.getTypeHandler(javaClass);
                }
                catch (Exception e) {
                    throw new SqlMapException("Error.  Could not set TypeHandler.  Cause: " + e, e);
                }
            }
        } else if (TypeHandlerFactory.getTypeHandler(clazz) != null) {
            handler = TypeHandlerFactory.getTypeHandler(clazz);
        } else {
            Class type = BeanProbe.getPropertyTypeForGetter((Class)clazz, (String)propertyName);
            handler = TypeHandlerFactory.getTypeHandler(type);
        }
        return handler;
    }

    private boolean isErrorTracingEnabled() {
        Boolean errorTracing = (Boolean)this.getContextObject(KEY_ERROR_TRACING);
        return errorTracing == null || errorTracing != false;
    }

    private boolean isStatementNamespacesEnabled() {
        Boolean useStatementNamespaces = (Boolean)this.getContextObject(KEY_STATEMENT_NAMESPACES);
        return useStatementNamespaces != null && useStatementNamespaces != false;
    }

    private String resolveAlias(String string) {
        String newString = null;
        if (this.typeAliases.containsKey(string)) {
            newString = (String)this.typeAliases.get(string);
        }
        if (newString != null) {
            string = newString;
        }
        return string;
    }

    private void parseTypeAliasNode(Node child) {
        Properties prop = this.parseAttributes(child);
        String alias = prop.getProperty("alias");
        String type = prop.getProperty("type");
        this.putTypeAlias(alias, type);
    }

    private void putTypeAlias(String alias, String value) {
        if (this.typeAliases.containsKey(alias)) {
            throw new SqlMapException("Error in XmlSqlMapClientBuilder.  Alias name conflict occurred.  The alias '" + alias + "' is already mapped to the value '" + this.typeAliases.get(alias) + "'.");
        }
        this.typeAliases.put(alias, value);
    }

    private void addNameValuePairProperty(Node child, Properties modelProperties) {
        Properties prop = this.parseAttributes(child);
        String name = prop.getProperty("name");
        String value = prop.getProperty("value");
        modelProperties.setProperty(name, value);
    }

    private void setContextObject(Object key, Object value) {
        this.contextPropertiesMap.put(key, value);
    }

    private Object getContextObject(Object key) {
        return this.contextPropertiesMap.get(key);
    }

    private void setSubContextObject(Object group, Object key, Object value) {
        HashMap<Object, Object> map = (HashMap<Object, Object>)this.contextPropertiesMap.get(group);
        if (map == null) {
            map = new HashMap<Object, Object>();
            this.contextPropertiesMap.put(group, map);
        }
        map.put(key, value);
    }

    private Object getSubContextObject(Object group, Object key) {
        Map map = (Map)this.contextPropertiesMap.get(group);
        Object result = null;
        if (map != null) {
            result = map.get(key);
        }
        return result;
    }

    private Properties parseAttributes(Node n) {
        Properties attributes = new Properties();
        NamedNodeMap attributeNodes = n.getAttributes();
        int i = 0;
        while (i < attributeNodes.getLength()) {
            Node attribute = attributeNodes.item(i);
            String value = this.parsePropertyTokens(attribute.getNodeValue());
            attributes.put(attribute.getNodeName(), value);
            ++i;
        }
        return attributes;
    }

    private String parsePropertyTokens(String string) {
        String OPEN = "${";
        String CLOSE = "}";
        Properties props = (Properties)this.contextPropertiesMap.get(KEY_GLOBAL_PROPS);
        String newString = string;
        if (newString != null && props != null) {
            int start = newString.indexOf("${");
            int end = newString.indexOf("}");
            while (start > -1 && end > start) {
                String prepend = newString.substring(0, start);
                String append = newString.substring(end + "}".length());
                String propName = newString.substring(start + "${".length(), end);
                String propValue = props.getProperty(propName);
                newString = propValue == null ? prepend + propName + append : prepend + propValue + append;
                start = newString.indexOf("${");
                end = newString.indexOf("}");
            }
        }
        return newString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SimpleErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        SimpleErrorHandler(PrintWriter out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

