/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.cache.fifo;

import com.ibatis.sqlmap.engine.cache.CacheController;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FifoCacheController
implements CacheController {
    private int cacheSize = 100;
    private Map cache = new HashMap();
    private List keyList = new ArrayList();

    public void configure(Properties props) {
        String size = props.getProperty("cache-size");
        if (size == null) {
            size = props.getProperty("size");
        }
        if (size != null) {
            this.cacheSize = Integer.parseInt(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(CacheModel cacheModel, Object key, Object value) {
        FifoCacheController fifoCacheController = this;
        synchronized (fifoCacheController) {
            this.cache.put(key, value);
            this.keyList.add(key);
            if (this.keyList.size() > this.cacheSize) {
                Object oldestKey = this.keyList.remove(0);
                this.cache.remove(oldestKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(CacheModel cacheModel, Object key) {
        FifoCacheController fifoCacheController = this;
        synchronized (fifoCacheController) {
            return this.cache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeObject(CacheModel cacheModel, Object key) {
        FifoCacheController fifoCacheController = this;
        synchronized (fifoCacheController) {
            return this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(CacheModel cacheModel) {
        FifoCacheController fifoCacheController = this;
        synchronized (fifoCacheController) {
            this.cache.clear();
            this.keyList.clear();
        }
    }
}

