/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.datasource;

import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.datasource.DataSourceFactory;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;

public class DbcpDataSourceFactory
implements DataSourceFactory {
    private DataSource dataSource;
    private String[] expectedProperties = new String[]{"JDBC.Driver", "JDBC.ConnectionURL", "JDBC.Username", "JDBC.Password", "Pool.ValidationQuery", "Pool.MaximumActiveConnections", "Pool.MaximumIdleConnections", "Pool.MaximumWait", "Pool.LogAbandoned", "Pool.RemoveAbandoned", "Pool.RemoveAbandonedTimeout"};

    public void initialize(Map map) {
        try {
            String driver = (String)map.get("JDBC.Driver");
            String url = (String)map.get("JDBC.ConnectionURL");
            String username = (String)map.get("JDBC.Username");
            String password = (String)map.get("JDBC.Password");
            String validationQuery = (String)map.get("Pool.ValidationQuery");
            String maxActive = (String)map.get("Pool.MaximumActiveConnections");
            String maxIdle = (String)map.get("Pool.MaximumIdleConnections");
            String maxWait = (String)map.get("Pool.MaximumWait");
            String removeAbandoned = (String)map.get("Pool.RemoveAbandoned");
            String removeAbandonedTimeout = (String)map.get("Pool.RemoveAbandonedTimeout");
            String logAbandoned = (String)map.get("Pool.LogAbandoned");
            BasicDataSource basicDataSource = new BasicDataSource();
            basicDataSource.setUrl(url);
            basicDataSource.setDriverClassName(driver);
            basicDataSource.setUsername(username);
            basicDataSource.setPassword(password);
            if (this.notEmpty(validationQuery)) {
                basicDataSource.setValidationQuery(validationQuery);
            }
            if (this.notEmpty(maxActive)) {
                basicDataSource.setMaxActive(Integer.parseInt(maxActive));
            }
            if (this.notEmpty(maxIdle)) {
                basicDataSource.setMaxIdle(Integer.parseInt(maxIdle));
            }
            if (this.notEmpty(maxWait)) {
                basicDataSource.setMaxWait((long)Integer.parseInt(maxWait));
            }
            if (this.notEmpty(removeAbandonedTimeout)) {
                basicDataSource.setRemoveAbandonedTimeout(Integer.parseInt(removeAbandonedTimeout));
            }
            if (this.notEmpty(removeAbandoned)) {
                basicDataSource.setRemoveAbandoned("true".equals(removeAbandoned));
            }
            if (this.notEmpty(logAbandoned)) {
                basicDataSource.setLogAbandoned("true".equals(logAbandoned));
            }
            this.dataSource = basicDataSource;
        }
        catch (Exception e) {
            throw new SqlMapException("Error initializing DbcpDataSourceFactory.  Cause: " + e, e);
        }
    }

    private boolean notEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String[] getExpectedProperties() {
        return this.expectedProperties;
    }
}

