/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.exchange;

import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.engine.accessplan.AccessPlan;
import com.ibatis.sqlmap.engine.accessplan.AccessPlanFactory;
import com.ibatis.sqlmap.engine.exchange.BaseDataExchange;
import com.ibatis.sqlmap.engine.exchange.DataExchange;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import java.util.Map;

public class JavaBeanDataExchange
extends BaseDataExchange
implements DataExchange {
    private static final Object[] NO_DATA = new Object[0];
    private AccessPlan resultPlan;
    private AccessPlan parameterPlan;

    public void initialize(Map properties) {
        ResultMap resultMap;
        Object map = properties.get("map");
        if (map instanceof ParameterMap) {
            ParameterMap parameterMap = (ParameterMap)map;
            if (parameterMap != null) {
                ParameterMapping[] parameterMappings = parameterMap.getParameterMappings();
                String[] parameterPropNames = new String[parameterMappings.length];
                int i = 0;
                while (i < parameterPropNames.length) {
                    parameterPropNames[i] = parameterMappings[i].getPropertyName();
                    ++i;
                }
                this.parameterPlan = AccessPlanFactory.getAccessPlan(parameterMap.getParameterClass(), parameterPropNames);
            }
        } else if (map instanceof ResultMap && (resultMap = (ResultMap)map) != null) {
            ResultMapping[] resultMappings = resultMap.getResultMappings();
            String[] resultPropNames = new String[resultMappings.length];
            int i = 0;
            while (i < resultPropNames.length) {
                resultPropNames[i] = resultMappings[i].getPropertyName();
                ++i;
            }
            this.resultPlan = AccessPlanFactory.getAccessPlan(resultMap.getResultClass(), resultPropNames);
        }
    }

    public Object[] getData(RequestScope request, ParameterMap parameterMap, Object parameterObject) {
        if (this.parameterPlan != null) {
            return this.parameterPlan.getProperties(parameterObject);
        }
        return NO_DATA;
    }

    public Object setData(RequestScope request, ResultMap resultMap, Object resultObject, Object[] values) {
        if (this.resultPlan != null) {
            Object object = resultObject;
            if (object == null) {
                try {
                    object = Resources.instantiate((Class)resultMap.getResultClass());
                }
                catch (Exception e) {
                    throw new NestedRuntimeException("JavaBeansDataExchange could not instantiate result class.  Cause: " + e, (Throwable)e);
                }
            }
            this.resultPlan.setProperties(object, values);
            return object;
        }
        return null;
    }

    public Object setData(RequestScope request, ParameterMap parameterMap, Object parameterObject, Object[] values) {
        if (this.parameterPlan != null) {
            Object object = parameterObject;
            if (object == null) {
                try {
                    object = Resources.instantiate((Class)parameterMap.getParameterClass());
                }
                catch (Exception e) {
                    throw new NestedRuntimeException("JavaBeansDataExchange could not instantiate parameter class.  Cause: " + e, (Throwable)e);
                }
            }
            this.parameterPlan.setProperties(object, values);
            return object;
        }
        return null;
    }
}

