/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result;

import com.ibatis.common.beans.BeanProbe;
import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.common.minixml.MiniDom;
import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.exchange.DataExchange;
import com.ibatis.sqlmap.engine.exchange.DataExchangeFactory;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.mapping.result.BasicResultMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.mapping.result.XmlList;
import com.ibatis.sqlmap.engine.mapping.result.loader.ResultLoader;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class BasicResultMap
implements ResultMap {
    protected String id;
    protected Class resultClass;
    protected ResultMapping[] resultMappings;
    protected DataExchange dataExchange;
    private String xmlName;
    private String resource;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$XmlTypeMarker;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker;
    static /* synthetic */ Class class$java$lang$String;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(Class resultClass) {
        this.resultClass = resultClass;
    }

    public DataExchange getDataExchange() {
        return this.dataExchange;
    }

    public void setDataExchange(DataExchange dataExchange) {
        this.dataExchange = dataExchange;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public void setXmlName(String xmlName) {
        this.xmlName = xmlName;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public ResultMapping[] getResultMappings() {
        return this.resultMappings;
    }

    public void setResultMappingList(List resultMappingList) {
        this.resultMappings = resultMappingList.toArray(new BasicResultMapping[resultMappingList.size()]);
        HashMap<String, BasicResultMap> props = new HashMap<String, BasicResultMap>();
        props.put("map", this);
        this.dataExchange = DataExchangeFactory.getDataExchangeForClass(this.resultClass);
        this.dataExchange.initialize(props);
    }

    public int getResultCount() {
        return this.resultMappings.length;
    }

    public Object[] getResults(RequestScope request, ResultSet rs) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("applying a result map");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        errorContext.setMoreInfo("Check the result map.");
        Object[] columnValues = new Object[this.resultMappings.length];
        int i = 0;
        while (i < this.resultMappings.length) {
            BasicResultMapping mapping = (BasicResultMapping)this.resultMappings[i];
            errorContext.setMoreInfo(mapping.getErrorString());
            if (mapping.getStatementName() == null) {
                columnValues[i] = this.getPrimitiveResultMappingValue(rs, mapping);
            } else {
                if (this.resultClass == null) {
                    throw new SqlMapException("The result class was null when trying to get results for ResultMap named " + this.getId() + ".");
                }
                if ((class$java$util$Map == null ? BasicResultMap.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(this.resultClass)) {
                    columnValues[i] = this.getNestedResultMappingValue(request, rs, mapping, class$java$lang$Object == null ? BasicResultMap.class$("java.lang.Object") : class$java$lang$Object);
                } else if ((class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? BasicResultMap.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker") : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker).isAssignableFrom(this.resultClass)) {
                    Class javaType = mapping.getJavaType();
                    if (javaType == null) {
                        javaType = class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? BasicResultMap.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker") : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker;
                    }
                    columnValues[i] = this.getNestedResultMappingValue(request, rs, mapping, javaType);
                } else {
                    ClassInfo info = ClassInfo.getInstance((Class)this.resultClass);
                    Class type = info.getSetterType(mapping.getPropertyName());
                    columnValues[i] = this.getNestedResultMappingValue(request, rs, mapping, type);
                }
            }
            ++i;
        }
        return columnValues;
    }

    public Object setResultObjectValues(RequestScope request, Object resultObject, Object[] values) {
        return this.dataExchange.setData(request, this, resultObject, values);
    }

    protected Object getNestedResultMappingValue(RequestScope request, ResultSet rs, BasicResultMapping mapping, Class targetType) throws SQLException {
        try {
            String statementName = mapping.getStatementName();
            ExtendedSqlMapClient client = (ExtendedSqlMapClient)request.getSession().getSqlMapClient();
            MappedStatement mappedStatement = client.getMappedStatement(statementName);
            Class parameterType = mappedStatement.getParameterClass();
            Object parameterObject = null;
            parameterObject = parameterType == null ? this.prepareBeanParameterObject(rs, mapping, parameterType) : (TypeHandlerFactory.hasTypeHandler(parameterType) ? this.preparePrimitiveParameterObject(rs, mapping, parameterType) : ((class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker).isAssignableFrom(parameterType) ? this.prepareXmlParameterObject(rs, mapping) : this.prepareBeanParameterObject(rs, mapping, parameterType)));
            Sql sql = mappedStatement.getSql();
            ResultMap resultMap = sql.getResultMap(request, parameterObject);
            Class resultClass = resultMap.getResultClass();
            if (resultClass != null && !(class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker).isAssignableFrom(targetType)) {
                if ((class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.XmlCollectionTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker).isAssignableFrom(resultClass)) {
                    targetType = class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.XmlCollectionTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlCollectionTypeMarker;
                } else if ((class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker).isAssignableFrom(resultClass)) {
                    targetType = class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker;
                }
            }
            boolean setIgnoreDomRoot = false;
            if ((class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker) == targetType && !request.getSession().isIgnoreDomRoot()) {
                request.getSession().setIgnoreDomRoot(true);
                setIgnoreDomRoot = true;
            }
            Object result = ResultLoader.loadResult(client, statementName, parameterObject, targetType);
            if (setIgnoreDomRoot) {
                request.getSession().setIgnoreDomRoot(false);
            }
            if ((class$com$ibatis$sqlmap$engine$type$XmlTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$XmlTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.XmlTypeMarker")) : class$com$ibatis$sqlmap$engine$type$XmlTypeMarker).isAssignableFrom(targetType) && result instanceof List) {
                result = new XmlList((List)result);
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new NestedSQLException("Error setting nested bean property.  Cause: " + e, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NestedSQLException("Error setting nested bean property.  Cause: " + e, (Throwable)e);
        }
    }

    private Object preparePrimitiveParameterObject(ResultSet rs, BasicResultMapping mapping, Class parameterType) throws SQLException {
        TypeHandler th = TypeHandlerFactory.getTypeHandler(parameterType);
        Object parameterObject = th.getResult(rs, mapping.getColumnName());
        return parameterObject;
    }

    private Object prepareXmlParameterObject(ResultSet rs, BasicResultMapping mapping) throws SQLException {
        MiniDom dom = new MiniDom("parameter");
        String complexName = mapping.getColumnName();
        TypeHandler stringTypeHandler = TypeHandlerFactory.getTypeHandler(class$java$lang$String == null ? (class$java$lang$String = BasicResultMap.class$("java.lang.String")) : class$java$lang$String);
        if (complexName.indexOf(61) > -1) {
            StringTokenizer parser = new StringTokenizer(complexName, "{}=, ", false);
            while (parser.hasMoreTokens()) {
                String propName = parser.nextToken();
                String colName = parser.nextToken();
                Object propValue = stringTypeHandler.getResult(rs, colName);
                dom.setValue(propName, propValue.toString());
            }
        } else {
            Object propValue = stringTypeHandler.getResult(rs, complexName);
            dom.setValue("value", propValue.toString());
        }
        String parameterObject = dom.toString();
        return parameterObject;
    }

    private Object prepareBeanParameterObject(ResultSet rs, BasicResultMapping mapping, Class parameterType) throws InstantiationException, IllegalAccessException, SQLException {
        HashMap parameterObject = parameterType == null ? new HashMap() : Resources.instantiate((Class)parameterType);
        String complexName = mapping.getColumnName();
        if (complexName.indexOf(61) > -1) {
            StringTokenizer parser = new StringTokenizer(complexName, "{}=, ", false);
            while (parser.hasMoreTokens()) {
                String propName = parser.nextToken();
                String colName = parser.nextToken();
                Class propType = BeanProbe.getPropertyTypeForSetter((Object)parameterObject, (String)propName);
                TypeHandler propTypeHandler = TypeHandlerFactory.getTypeHandler(propType);
                Object propValue = propTypeHandler.getResult(rs, colName);
                BeanProbe.setObject((Object)parameterObject, (String)propName, (Object)propValue);
            }
        } else {
            TypeHandler propTypeHandler = TypeHandlerFactory.getTypeHandler(parameterType);
            parameterObject = propTypeHandler.getResult(rs, complexName);
        }
        return parameterObject;
    }

    protected Object getPrimitiveResultMappingValue(ResultSet rs, BasicResultMapping mapping) throws SQLException {
        TypeHandler typeHandler = mapping.getTypeHandler();
        String columnName = mapping.getColumnName();
        int columnIndex = mapping.getColumnIndex();
        String nullValue = mapping.getNullValue();
        Object value = null;
        value = columnName == null ? typeHandler.getResult(rs, columnIndex) : typeHandler.getResult(rs, columnName);
        if (value == null && nullValue != null) {
            value = typeHandler.valueOf(nullValue);
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

