/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.transaction.jta;

import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class JtaTransaction
implements Transaction {
    private UserTransaction userTransaction;
    private DataSource dataSource;
    private Connection connection;
    private boolean commmitted = false;
    private boolean newTransaction = false;

    public JtaTransaction(UserTransaction utx, DataSource ds) throws SQLException, TransactionException {
        this.userTransaction = utx;
        this.dataSource = ds;
        if (this.userTransaction == null) {
            throw new TransactionException("JtaTransaction initialization failed.  UserTransaction was null.");
        }
        if (this.dataSource == null) {
            throw new TransactionException("JtaTransaction initialization failed.  DataSource was null.");
        }
        try {
            boolean bl = this.newTransaction = this.userTransaction.getStatus() == 6;
            if (this.newTransaction) {
                this.userTransaction.begin();
            }
        }
        catch (Exception e) {
            throw new TransactionException("JtaTransaction could not start transaction.  Cause: ", e);
        }
        this.connection = this.dataSource.getConnection();
        if (this.connection == null) {
            throw new TransactionException("JtaTransaction could not start transaction.  Cause: The DataSource returned a null connection.");
        }
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
    }

    public void commit() throws SQLException, TransactionException {
        if (this.commmitted) {
            throw new TransactionException("JtaTransaction could not commit because this transaction has already been committed.");
        }
        try {
            if (this.newTransaction) {
                this.userTransaction.commit();
            }
        }
        catch (Exception e) {
            throw new TransactionException("JtaTransaction could not commit.  Cause: ", e);
        }
        this.commmitted = true;
    }

    public void rollback() throws SQLException, TransactionException {
        if (!this.commmitted) {
            try {
                if (this.userTransaction != null) {
                    if (this.newTransaction) {
                        this.userTransaction.rollback();
                    } else {
                        this.userTransaction.setRollbackOnly();
                    }
                }
            }
            catch (Exception e) {
                throw new TransactionException("JtaTransaction could not rollback.  Cause: ", e);
            }
        }
    }

    public void close() throws SQLException, TransactionException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public Connection getConnection() throws SQLException, TransactionException {
        return this.connection;
    }
}

