/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateOnlyTypeHandler
implements TypeHandler {
    private static final String DATE_FORMAT = "yyyy/MM/dd";
    private static final DateFormat format = new SimpleDateFormat("yyyy/MM/dd");

    public void setParameter(PreparedStatement ps, int i, Object parameter) throws SQLException {
        ps.setDate(i, new java.sql.Date(((Date)parameter).getTime()));
    }

    public Object getResult(ResultSet rs, String columnName) throws SQLException {
        java.sql.Date sqlDate = rs.getDate(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return new Date(sqlDate.getTime());
    }

    public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
        java.sql.Date sqlDate = rs.getDate(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return new Date(sqlDate.getTime());
    }

    public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
        java.sql.Date sqlDate = cs.getDate(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return new Date(sqlDate.getTime());
    }

    public Object valueOf(String s) {
        try {
            return format.parse(s);
        }
        catch (ParseException e) {
            throw new SqlMapException("Error parsing default null value date.  Format must be 'yyyy/MM/dd'. Cause: " + e);
        }
    }
}

