/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeOnlyTypeHandler
implements TypeHandler {
    private static final String DATE_FORMAT = "hh:mm:ss";
    private static final DateFormat format = new SimpleDateFormat("hh:mm:ss");

    public void setParameter(PreparedStatement ps, int i, Object parameter) throws SQLException {
        ps.setTime(i, new Time(((Date)parameter).getTime()));
    }

    public Object getResult(ResultSet rs, String columnName) throws SQLException {
        Time sqlTime = rs.getTime(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return new Date(sqlTime.getTime());
    }

    public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
        Time sqlTime = rs.getTime(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return new Date(sqlTime.getTime());
    }

    public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
        Time sqlTime = cs.getTime(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return new Date(sqlTime.getTime());
    }

    public Object valueOf(String s) {
        try {
            return format.parse(s);
        }
        catch (ParseException e) {
            throw new SqlMapException("Error parsing default null value date.  Format must be 'hh:mm:ss'. Cause: " + e);
        }
    }
}

