/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.impl.jdbcjobstore.Constants;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import org.quartz.impl.jdbcjobstore.Util;

public class StdRowLockSemaphore
implements Semaphore,
Constants,
StdJDBCConstants {
    public static final String SELECT_FOR_LOCK = "SELECT * FROM {0}LOCKS WHERE LOCK_NAME = ? FOR UPDATE";
    ThreadLocal lockOwners = new ThreadLocal();
    private String selectWithLockSQL = "SELECT * FROM {0}LOCKS WHERE LOCK_NAME = ? FOR UPDATE";
    private String tablePrefix;

    public StdRowLockSemaphore(String tablePrefix, String selectWithLockSQL) {
        this.tablePrefix = tablePrefix;
        if (selectWithLockSQL != null && selectWithLockSQL.trim().length() != 0) {
            this.selectWithLockSQL = selectWithLockSQL;
        }
        this.selectWithLockSQL = Util.rtp(this.selectWithLockSQL, tablePrefix);
    }

    Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    private HashSet getThreadLocks() {
        HashSet threadLocks = (HashSet)this.lockOwners.get();
        if (threadLocks == null) {
            threadLocks = new HashSet();
            this.lockOwners.set(threadLocks);
        }
        return threadLocks;
    }

    /*
     * Loose catch block
     */
    public boolean obtainLock(Connection conn, String lockName) throws LockException {
        block17: {
            block15: {
                block16: {
                    Exception ignore22;
                    ResultSet rs;
                    PreparedStatement ps;
                    block14: {
                        lockName = lockName.intern();
                        this.getLog().debug((Object)("Lock '" + lockName + "' is desired by: " + Thread.currentThread().getName()));
                        if (this.isLockOwner(conn, lockName)) break block15;
                        ps = null;
                        rs = null;
                        ps = conn.prepareStatement(this.selectWithLockSQL);
                        ps.setString(1, lockName);
                        this.getLog().debug((Object)("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName()));
                        rs = ps.executeQuery();
                        if (!rs.next()) {
                            throw new SQLException(Util.rtp("No row exists in table {0}LOCKS for lock named: " + lockName, this.tablePrefix));
                        }
                        Object var7_5 = null;
                        if (rs == null) break block14;
                        try {
                            rs.close();
                        }
                        catch (Exception ignore22) {
                            // empty catch block
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Exception ignore22) {}
                    }
                    break block16;
                    {
                        catch (SQLException sqle) {
                            this.getLog().debug((Object)("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName()));
                            throw new LockException("Failure obtaining db row lock: " + sqle.getMessage(), sqle);
                        }
                    }
                    catch (Throwable throwable) {
                        Exception ignore22;
                        Object var7_6 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Exception ignore22) {
                                // empty catch block
                            }
                        }
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Exception ignore22) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                this.getLog().debug((Object)("Lock '" + lockName + "' given to: " + Thread.currentThread().getName()));
                this.getThreadLocks().add(lockName);
                break block17;
            }
            this.getLog().debug((Object)("Lock '" + lockName + "' Is already owned by: " + Thread.currentThread().getName()));
        }
        return true;
    }

    public void releaseLock(Connection conn, String lockName) {
        if (this.isLockOwner(conn, lockName = lockName.intern())) {
            this.getLog().debug((Object)("Lock '" + lockName + "' retuned by: " + Thread.currentThread().getName()));
            this.getThreadLocks().remove(lockName);
        } else {
            this.getLog().warn((Object)("Lock '" + lockName + "' attempt to retun by: " + Thread.currentThread().getName() + " -- but not owner!"), (Throwable)new Exception("stack-trace of wrongful returner"));
        }
    }

    public boolean isLockOwner(Connection conn, String lockName) {
        lockName = lockName.intern();
        return this.getThreadLocks().contains(lockName);
    }
}

