/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfCell;
import com.lowagie.text.rtf.RtfRow;
import com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfTable {
    private ArrayList rowsList = new ArrayList();
    private RtfWriter writer = null;
    private Table origTable = null;

    public RtfTable(RtfWriter rtfWriter) {
        this.writer = rtfWriter;
    }

    public boolean importTable(Table table, int n) {
        RtfRow rtfRow;
        int n2;
        this.origTable = table;
        Iterator iterator = table.iterator();
        Row row = null;
        int n3 = (int)table.widthPercentage();
        int n4 = (int)((double)table.cellpadding() * 20.0);
        int n5 = (int)((double)table.cellspacing() * 20.0);
        float[] fArray = table.getProportionalWidths();
        int n6 = table.border();
        Color color = table.borderColor();
        float f = table.borderWidth();
        for (n2 = 0; n2 < table.size(); ++n2) {
            rtfRow = new RtfRow(this.writer, this);
            rtfRow.pregenerateRows(table.columns());
            this.rowsList.add(rtfRow);
        }
        n2 = 0;
        while (iterator.hasNext()) {
            row = (Row)iterator.next();
            row.setHorizontalAlignment(table.alignment());
            rtfRow = (RtfRow)this.rowsList.get(n2);
            rtfRow.importRow(row, fArray, n3, n, n4, n5, n6, color, f, n2);
            ++n2;
        }
        return true;
    }

    public boolean writeTable(ByteArrayOutputStream byteArrayOutputStream) throws DocumentException, IOException {
        int n = this.rowsList.size();
        for (int i = 0; i < n; ++i) {
            RtfRow rtfRow = (RtfRow)this.rowsList.get(i);
            rtfRow.writeRow(byteArrayOutputStream, i, this.origTable);
            byteArrayOutputStream.write(10);
        }
        if (!this.writer.writingHeaderFooter()) {
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfWriter.paragraphDefaults);
            byteArrayOutputStream.write(92);
            byteArrayOutputStream.write(RtfWriter.paragraph);
        }
        return true;
    }

    public void setMerge(int n, int n2, int n3, RtfCell rtfCell) {
        RtfRow rtfRow = (RtfRow)this.rowsList.get(n2);
        rtfRow.setMerge(n, n3, rtfCell);
    }

    protected Table getOriginalTable() {
        return this.origTable;
    }
}

