/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.ant;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;

public class JythonAntTask
extends Task {
    private PythonInterpreter pythonInterpreter = new PythonInterpreter();
    private File scriptFile;
    private String code = "";

    public void setFile(File scriptFile) throws BuildException {
        this.scriptFile = scriptFile;
        String path = scriptFile.getParentFile().getAbsolutePath();
        Py.getSystemState().path.append((PyObject)new PyString(path));
    }

    public void addText(String text) {
        this.code = this.code + text;
    }

    public void execute() throws BuildException {
        try {
            if (this.scriptFile != null) {
                this.pythonInterpreter.execfile(this.scriptFile.getCanonicalPath());
            }
            if (this.code.trim().length() > 0) {
                this.pythonInterpreter.exec(ProjectHelper.replaceProperties((Project)this.project, (String)this.code, (Hashtable)this.project.getProperties()));
            }
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public PythonInterpreter getInterpreter() {
        return this.pythonInterpreter;
    }
}

