/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.support.SortDefinition;

public class PropertyComparator
implements Comparator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SortDefinition sortDefinition;
    private Map cachedBeanWrappers = new HashMap();

    public PropertyComparator(SortDefinition sortDefinition) {
        this.sortDefinition = sortDefinition;
    }

    /*
     * WARNING - void declaration
     */
    public int compare(Object o1, Object o2) {
        void var5_5;
        block5: {
            Object v1 = this.getPropertyValue(o1);
            Object v2 = this.getPropertyValue(o2);
            if (this.sortDefinition.isIgnoreCase() && v1 instanceof String && v2 instanceof String) {
                v1 = ((String)v1).toLowerCase();
                v2 = ((String)v2).toLowerCase();
            }
            try {
                int result;
                if (v1 != null) {
                    result = ((Comparable)v1).compareTo(v2);
                    break block5;
                }
                if (v2 != null) {
                    result = -((Comparable)v2).compareTo(v1);
                    break block5;
                }
                return 0;
            }
            catch (RuntimeException ex) {
                this.logger.warn((Object)("Could not sort objects [" + o1 + "] and [" + o2 + "]"), (Throwable)ex);
                return 0;
            }
        }
        return (int)(this.sortDefinition.isAscending() ? var5_5 : -var5_5);
    }

    private Object getPropertyValue(Object o) throws BeansException {
        BeanWrapper bw = (BeanWrapper)this.cachedBeanWrappers.get(o);
        if (bw == null) {
            bw = new BeanWrapperImpl(o);
            this.cachedBeanWrappers.put(o, bw);
        }
        return bw.getPropertyValue(this.sortDefinition.getProperty());
    }

    public static void sort(List source, SortDefinition sortDefinition) throws BeansException {
        Collections.sort(source, new PropertyComparator(sortDefinition));
    }

    public static void sort(Object[] source, SortDefinition sortDefinition) throws BeansException {
        Arrays.sort(source, new PropertyComparator(sortDefinition));
    }
}

