/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.Store;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryStore
implements Store,
Serializable {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$store$MemoryStore == null ? (class$net$sf$ehcache$store$MemoryStore = MemoryStore.class$("net.sf.ehcache.store.MemoryStore")) : class$net$sf$ehcache$store$MemoryStore).getName());
    private Map map;
    private Cache cache;
    private DiskStore diskStore;
    private int status = 1;
    static /* synthetic */ Class class$net$sf$ehcache$store$MemoryStore;

    public MemoryStore(Cache cache, DiskStore diskStore) {
        this.cache = cache;
        this.diskStore = diskStore;
        try {
            this.map = this.loadMapInstance();
        }
        catch (CacheException e) {
            LOG.error((Object)(cache.getName() + "Cache: Cannot start MemoryStore"), (Throwable)e);
            return;
        }
        LOG.debug((Object)("initialized MemoryStore for " + cache.getName()));
        this.status = 2;
    }

    public Map loadMapInstance() throws CacheException {
        try {
            Class.forName("java.util.LinkedHashMap");
            SpoolingLinkedHashMap map = new SpoolingLinkedHashMap();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.cache.getName() + " Cache: Using SpoolingLinkedHashMap implementation"));
            }
            return map;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.cache.getName() + " Cache: Cannot find java.util.LinkedHashMap"));
            }
            try {
                Class.forName("org.apache.commons.collections.LRUMap");
                SpoolingLRUMap map = new SpoolingLRUMap();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.cache.getName() + " Cache: Using SpoolingLRUMap implementation"));
                }
                return map;
            }
            catch (Exception e2) {
                throw new CacheException(this.cache.getName() + "Cache: Cannot find org.apache.commons.collections.LRUMap.");
            }
        }
    }

    public synchronized void put(Element element) {
        this.map.put(element.getKey(), element);
    }

    public synchronized void removeAll() {
        this.map.clear();
    }

    public synchronized Element get(Serializable key) {
        Element cacheElement = (Element)this.map.get(key);
        if (cacheElement != null) {
            cacheElement.updateAccessStatistics();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.cache.getName() + "Cache: MemoryStore hit for " + key));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.cache.getName() + "Cache: MemoryStore miss for " + key));
        }
        return cacheElement;
    }

    public synchronized boolean remove(Serializable key) {
        boolean removed = false;
        if (this.map.get(key) == null && LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.cache.getName() + "Cache: Cannot remove entry as key " + key + " was not found"));
        }
        if (this.map.remove(key) != null) {
            removed = true;
        }
        return removed;
    }

    public synchronized Object[] getKeyArray() {
        return this.map.keySet().toArray();
    }

    public int getSize() {
        return this.map.size();
    }

    public Cache getCache() {
        return this.cache;
    }

    public int getStatus() {
        return this.status;
    }

    public int getCacheType() {
        return 1;
    }

    public String getName() {
        return this.cache.getName();
    }

    public synchronized void dispose() {
        if (this.status == 3) {
            return;
        }
        this.status = 3;
        this.map.clear();
        this.cache = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SpoolingLinkedHashMap
    extends LinkedHashMap {
        public SpoolingLinkedHashMap() {
            super(100, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            Element element = (Element)eldest.getValue();
            if (MemoryStore.this.cache.isExpired(element)) {
                return true;
            }
            if (this.size() <= MemoryStore.this.cache.getMaxElementsInMemory()) {
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Memory Store maximum size of " + MemoryStore.this.cache.getMaxElementsInMemory() + " reached. About to spool element with key \"" + element.getKey() + "\" to Disk Store"));
            }
            if (MemoryStore.this.cache.isOverflowToDisk()) {
                this.spoolToDisk(element);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Memory Store size now: " + MemoryStore.this.map.size()));
            }
            return true;
        }

        private void spoolToDisk(Element element) {
            try {
                MemoryStore.this.diskStore.put(element);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException(e.getMessage());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(MemoryStore.this.cache.getName() + "Cache: spool to disk done for: " + element.getKey()));
            }
        }
    }

    public class SpoolingLRUMap
    extends LRUMap {
        public SpoolingLRUMap() {
            this.setMaximumSize(MemoryStore.this.cache.getMaxElementsInMemory());
        }

        protected void processRemovedLRU(Object key, Object value) {
            Element element = (Element)value;
            if (MemoryStore.this.cache.isExpired(element)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Memory Store maximum size of " + MemoryStore.this.cache.getMaxElementsInMemory() + " reached. About to spool element with key \"" + element.getKey() + "\" to Disk Store"));
            }
            if (MemoryStore.this.cache.isOverflowToDisk()) {
                this.spoolToDisk(element);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Memory Store size now: " + MemoryStore.this.map.size()));
            }
        }

        private void spoolToDisk(Element element) {
            try {
                MemoryStore.this.diskStore.put(element);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException(e.getMessage());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(MemoryStore.this.cache.getName() + "Cache: spool to disk done for: " + element.getKey()));
            }
        }
    }
}

