/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.jms;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.MockObject;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public class MockConnection
extends MockObject
implements Connection {
    protected ExpectationCounter myCloseCalls = new ExpectationCounter("CommonMockConnection.close");
    protected ExpectationCounter myStartCalls = new ExpectationCounter("CommonMockConnection.start");
    protected ExpectationCounter myStopCalls = new ExpectationCounter("CommonMockConnection.stop");
    private JMSException myException;

    public void close() throws JMSException {
        this.myCloseCalls.inc();
        this.throwExceptionIfAny();
    }

    public String getClientID() throws JMSException {
        this.notImplemented();
        return null;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.notImplemented();
        return null;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.notImplemented();
        return null;
    }

    public void setClientID(String clientID) throws JMSException {
        this.notImplemented();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
    }

    public void start() throws JMSException {
        this.myStartCalls.inc();
        this.throwExceptionIfAny();
    }

    public void stop() throws JMSException {
        this.myStopCalls.inc();
        this.throwExceptionIfAny();
    }

    public void setExpectedCloseCalls(int callCount) {
        this.myCloseCalls.setExpected(callCount);
    }

    public void setExpectedStartCalls(int callCount) {
        this.myStartCalls.setExpected(callCount);
    }

    public void setExpectedStopCalls(int callCount) {
        this.myStopCalls.setExpected(callCount);
    }

    public void setupThrowException(JMSException e) {
        this.myException = e;
    }

    protected void throwExceptionIfAny() throws JMSException {
        if (null != this.myException) {
            throw this.myException;
        }
    }
}

