/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.jms;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.MockObject;
import javax.jms.JMSException;
import javax.jms.MessageProducer;

public abstract class MockMessageProducer
extends MockObject
implements MessageProducer {
    protected final ExpectationCounter myCloseCalls = new ExpectationCounter("MockMessageConsumer.close");
    private JMSException myException;

    public void close() throws JMSException {
        this.myCloseCalls.inc();
    }

    public int getDeliveryMode() throws JMSException {
        this.notImplemented();
        return 0;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.notImplemented();
        return false;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.notImplemented();
        return false;
    }

    public int getPriority() throws JMSException {
        this.notImplemented();
        return 0;
    }

    public long getTimeToLive() throws JMSException {
        this.notImplemented();
        return 0L;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.notImplemented();
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.notImplemented();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.notImplemented();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.notImplemented();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.notImplemented();
    }

    public void setExpectedCloseCalls(int callCount) {
        this.myCloseCalls.setExpected(callCount);
    }

    public void setupThrowException(JMSException e) {
        this.myException = e;
    }

    protected void throwExceptionIfAny() throws JMSException {
        if (null != this.myException) {
            throw this.myException;
        }
    }
}

