/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.lang.reflect.Method;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.UnionPointcut;

public abstract class Pointcuts {
    public static Pointcut union(Pointcut a, Pointcut b) {
        return new UnionPointcut(a, b);
    }

    public static Pointcut intersection(Pointcut a, Pointcut b) {
        return new ComposablePointcut(a.getClassFilter(), a.getMethodMatcher()).intersection(b);
    }

    public static boolean matches(Pointcut pc, Method m, Class targetClass, Object[] arguments) {
        MethodMatcher mm;
        if (pc == Pointcut.TRUE) {
            return true;
        }
        if (pc.getClassFilter().matches(targetClass) && (mm = pc.getMethodMatcher()).matches(m, targetClass)) {
            return mm.isRuntime() ? mm.matches(m, targetClass, arguments) : true;
        }
        return false;
    }

    public static boolean equals(Pointcut a, Pointcut b) {
        return a.getClassFilter() == b.getClassFilter() && a.getMethodMatcher() == b.getMethodMatcher();
    }
}

