/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopConfigException;

public class HotSwappableTargetSource
implements TargetSource {
    private Object target;

    public HotSwappableTargetSource(Object initialTarget) {
        this.target = initialTarget;
    }

    public Class getTargetClass() {
        return this.target.getClass();
    }

    public final boolean isStatic() {
        return false;
    }

    public final synchronized Object getTarget() {
        return this.target;
    }

    public void releaseTarget(Object o) {
    }

    public synchronized Object swap(Object newTarget) throws AopConfigException {
        if (newTarget == null) {
            throw new AopConfigException("Cannot swap to null");
        }
        Object old = this.target;
        this.target = newTarget;
        return old;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HotSwappableTargetSource)) {
            return false;
        }
        HotSwappableTargetSource otherTargetSource = (HotSwappableTargetSource)other;
        return otherTargetSource.target == this.target || otherTargetSource.target.equals(this.target);
    }
}

