/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenSessionInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private String sessionFactoryBeanName = "sessionFactory";

    public void setSessionFactoryBeanName(String sessionFactoryBeanName) {
        this.sessionFactoryBeanName = sessionFactoryBeanName;
    }

    protected String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    protected String getAlreadyFilteredAttributeName() {
        return this.getClass().getName() + "." + this.sessionFactoryBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SessionFactory sessionFactory = this.lookupSessionFactory();
        this.logger.debug((Object)"Opening Hibernate Session in OpenSessionInViewFilter");
        Session session = this.getSession(sessionFactory);
        TransactionSynchronizationManager.bindResource(sessionFactory, new SessionHolder(session));
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            TransactionSynchronizationManager.unbindResource(sessionFactory);
            this.logger.debug((Object)"Closing Hibernate Session in OpenSessionInViewFilter");
            this.closeSession(session, sessionFactory);
            throw throwable;
        }
        TransactionSynchronizationManager.unbindResource(sessionFactory);
        this.logger.debug((Object)"Closing Hibernate Session in OpenSessionInViewFilter");
        this.closeSession(session, sessionFactory);
    }

    protected SessionFactory lookupSessionFactory() {
        this.logger.info((Object)("Using SessionFactory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInViewFilter"));
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext());
        return (SessionFactory)wac.getBean(this.getSessionFactoryBeanName());
    }

    protected Session getSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        Session session = SessionFactoryUtils.getSession(sessionFactory, true);
        session.setFlushMode(FlushMode.NEVER);
        return session;
    }

    protected void closeSession(Session session, SessionFactory sessionFactory) throws CleanupFailureDataAccessException {
        SessionFactoryUtils.closeSessionIfNecessary(session, sessionFactory);
    }
}

