/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.springframework.web.util.ExpressionEvaluationUtils;

public class HtmlEscapeTag
extends TagSupport {
    public static final String HTML_ESCAPE_CONTEXT_PARAM = "defaultHtmlEscape";
    public static final String HTML_ESCAPE_PAGE_ATTR = "org.springframework.web.servlet.tags.HTML_ESCAPE";
    private String defaultHtmlEscape;

    public void setDefaultHtmlEscape(String defaultHtmlEscape) throws JspException {
        this.defaultHtmlEscape = defaultHtmlEscape;
    }

    public int doStartTag() throws JspException {
        super.doStartTag();
        boolean resolvedDefaultHtmlEscape = ExpressionEvaluationUtils.evaluateBoolean(HTML_ESCAPE_CONTEXT_PARAM, this.defaultHtmlEscape, this.pageContext);
        this.pageContext.setAttribute(HTML_ESCAPE_PAGE_ATTR, (Object)new Boolean(resolvedDefaultHtmlEscape));
        return 1;
    }

    public static boolean isDefaultHtmlEscape(PageContext pageContext) {
        Boolean defaultValue = (Boolean)pageContext.getAttribute(HTML_ESCAPE_PAGE_ATTR);
        if (defaultValue != null) {
            return defaultValue;
        }
        String param = pageContext.getServletContext().getInitParameter(HTML_ESCAPE_CONTEXT_PARAM);
        return Boolean.valueOf(param);
    }
}

