/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import com.opensymphony.oscache.base.Config;
import java.util.Properties;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheProvider;
import net.sf.hibernate.cache.OSCache;
import net.sf.hibernate.cache.Timestamper;
import net.sf.hibernate.util.PropertiesHelper;
import net.sf.hibernate.util.StringHelper;

public class OSCacheProvider
implements CacheProvider {
    public static final String OSCACHE_REFRESH_PERIOD = "refresh.period";
    public static final String OSCACHE_CRON = "cron";
    public static final String OSCACHE_CAPACITY = "capacity";
    private static final Properties OSCACHE_PROPERTIES = new Config().getProperties();

    public Cache buildCache(String region, Properties properties) throws CacheException {
        int refreshPeriod = PropertiesHelper.getInt(StringHelper.qualify(region, OSCACHE_REFRESH_PERIOD), OSCACHE_PROPERTIES, -1);
        String cron = OSCACHE_PROPERTIES.getProperty(StringHelper.qualify(region, OSCACHE_CRON));
        OSCache cache = new OSCache(refreshPeriod, cron);
        Integer capacity = PropertiesHelper.getInteger(StringHelper.qualify(region, OSCACHE_CAPACITY), OSCACHE_PROPERTIES);
        if (capacity != null) {
            cache.setCacheCapacity(capacity);
        }
        return cache;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }
}

