/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class MatchMode
implements Serializable {
    private final int intCode;
    private final String name;
    private static final Map INSTANCES = new HashMap();
    public static final MatchMode EXACT = new MatchMode(0, "EXACT"){

        String toMatchString(String pattern) {
            return pattern;
        }
    };
    public static final MatchMode START = new MatchMode(1, "START"){

        String toMatchString(String pattern) {
            return pattern + '%';
        }
    };
    public static final MatchMode END = new MatchMode(2, "END"){

        String toMatchString(String pattern) {
            return '%' + pattern;
        }
    };
    public static final MatchMode ANYWHERE = new MatchMode(3, "ANYWHERE"){

        String toMatchString(String pattern) {
            return '%' + pattern + '%';
        }
    };

    protected MatchMode(int intCode, String name) {
        this.intCode = intCode;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    private Object readResolve() {
        return INSTANCES.get(new Integer(this.intCode));
    }

    abstract String toMatchString(String var1);

    static {
        INSTANCES.put(new Integer(MatchMode.EXACT.intCode), EXACT);
        INSTANCES.put(new Integer(MatchMode.END.intCode), END);
        INSTANCES.put(new Integer(MatchMode.START.intCode), START);
        INSTANCES.put(new Integer(MatchMode.ANYWHERE.intCode), ANYWHERE);
    }
}

