/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.util;

import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;

public class JoinedIterator
implements Iterator {
    private Iterator[] iterators;
    private int currentIteratorIndex;
    private Iterator currentIterator;
    private Iterator lastUsedIterator;

    public JoinedIterator(Iterator[] iterators) {
        if (iterators == null) {
            throw new NullPointerException("Unexpected NULL iterators argument");
        }
        this.iterators = iterators;
    }

    public JoinedIterator(Iterator first, Iterator second) {
        this(new Iterator[]{first, second});
    }

    public boolean hasNext() {
        this.updateCurrentIterator();
        return this.currentIterator.hasNext();
    }

    public Object next() {
        this.updateCurrentIterator();
        return this.currentIterator.next();
    }

    public void remove() {
        this.updateCurrentIterator();
        this.lastUsedIterator.remove();
    }

    protected void updateCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iterators.length == 0 ? IteratorUtils.EMPTY_ITERATOR : this.iterators[0];
            this.lastUsedIterator = this.currentIterator;
        }
        while (!this.currentIterator.hasNext() && this.currentIteratorIndex < this.iterators.length - 1) {
            ++this.currentIteratorIndex;
            this.currentIterator = this.iterators[this.currentIteratorIndex];
        }
    }
}

