/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.flatfile;

import com.ibatis.common.flatfile.FlatFileIn;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;

public class FixedColFlatFileIn
implements FlatFileIn {
    private LineNumberReader reader = null;
    private ArrayList values = new ArrayList();
    private int[] coldef = null;
    private int linelength = 0;

    public FixedColFlatFileIn(String string, int[] nArray) throws IOException {
        this.reader = new LineNumberReader(new FileReader(string));
        this.coldef = nArray;
        int n = 0;
        while (n < nArray.length) {
            this.linelength += nArray[n];
            ++n;
        }
    }

    public int getColumnCount() throws IOException {
        return this.coldef.length;
    }

    public String getValueAt(int n) throws IOException {
        return (String)this.values.get(n);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean nextRecord() throws IOException {
        this.values.clear();
        String string = this.reader.readLine();
        if (string == null) {
            return false;
        }
        if (string.length() != this.linelength) {
            throw new IOException("Inconsistent length of row.");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.coldef.length) {
            this.values.add(string.substring(n, this.coldef[n2] + n).trim());
            n += this.coldef[n2];
            ++n2;
        }
        return true;
    }
}

