/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class I18NHelper {
    private static Hashtable bundles = new Hashtable();
    private static Hashtable helpers = new Hashtable();
    private static Locale locale = Locale.getDefault();
    private ResourceBundle bundle = null;
    private static final String bundleSuffix = ".Bundle";
    static /* synthetic */ Class class$javax$jdo$I18NHelper;

    private I18NHelper() {
    }

    private I18NHelper(String string, ClassLoader classLoader) {
        this.bundle = I18NHelper.loadBundle(string, classLoader);
    }

    public static I18NHelper getInstance(String string) {
        return I18NHelper.getInstance(string, (class$javax$jdo$I18NHelper == null ? (class$javax$jdo$I18NHelper = I18NHelper.class$("javax.jdo.I18NHelper")) : class$javax$jdo$I18NHelper).getClassLoader());
    }

    public static I18NHelper getInstance(final Class clazz) {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
        String string = I18NHelper.getPackageName(clazz.getName()) + bundleSuffix;
        return I18NHelper.getInstance(string, classLoader);
    }

    public static I18NHelper getInstance(String string, ClassLoader classLoader) {
        I18NHelper i18NHelper = (I18NHelper)helpers.get(string);
        if (i18NHelper != null) {
            return i18NHelper;
        }
        i18NHelper = new I18NHelper(string, classLoader);
        helpers.put(string, i18NHelper);
        return (I18NHelper)helpers.get(string);
    }

    public String msg(String string) {
        return I18NHelper.getMessage(this.bundle, string);
    }

    public String msg(String string, Object object) {
        return I18NHelper.getMessage(this.bundle, string, object);
    }

    public String msg(String string, Object object, Object object2) {
        return I18NHelper.getMessage(this.bundle, string, object, object2);
    }

    public String msg(String string, Object object, Object object2, Object object3) {
        return I18NHelper.getMessage(this.bundle, string, object, object2, object3);
    }

    public String msg(String string, Object[] objectArray) {
        return I18NHelper.getMessage(this.bundle, string, objectArray);
    }

    public String msg(String string, int n) {
        return I18NHelper.getMessage(this.bundle, string, n);
    }

    public String msg(String string, boolean bl) {
        return I18NHelper.getMessage(this.bundle, string, bl);
    }

    private static final ResourceBundle loadBundle(String string, ClassLoader classLoader) {
        ResourceBundle resourceBundle = (ResourceBundle)bundles.get(string);
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
            bundles.put(string, resourceBundle);
        }
        return resourceBundle;
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string) {
        return resourceBundle.getString(string);
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                objectArray[n] = "";
            }
            ++n;
        }
        MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(string));
        return messageFormat.format(objectArray);
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string, int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    private static final String getMessage(ResourceBundle resourceBundle, String string, boolean bl) {
        Object[] objectArray = new Object[]{String.valueOf(bl)};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    private static final String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(0, n) : "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

