/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.spi.I18NHelper;

public class JDOException
extends RuntimeException {
    Throwable[] nested;
    Object failed;
    private static I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    private static String MSG_FAILED_OBJECT = "\n" + msg.msg("MSG_FailedObject");
    private static String MSG_NESTED_THROWABLES_STACK_TRACE = msg.msg("MSG_NestedThrowablesStackTrace");
    private static String MSG_NESTED_THROWABLES = "\n" + msg.msg("MSG_NestedThrowables") + "\n";

    public JDOException() {
    }

    public JDOException(String string) {
        super(string);
    }

    public JDOException(String string, Throwable[] throwableArray) {
        super(string);
        this.nested = throwableArray;
    }

    public JDOException(String string, Throwable throwable) {
        super(string);
        this.nested = new Throwable[]{throwable};
    }

    public JDOException(String string, Object object) {
        super(string);
        this.failed = object;
    }

    public JDOException(String string, Throwable[] throwableArray, Object object) {
        super(string);
        this.nested = throwableArray;
        this.failed = object;
    }

    public JDOException(String string, Throwable throwable, Object object) {
        super(string);
        this.nested = new Throwable[]{throwable};
        this.failed = object;
    }

    public Object getFailedObject() {
        return this.failed;
    }

    public Throwable[] getNestedExceptions() {
        return this.nested;
    }

    public Throwable getCause() {
        if (this.nested == null || this.nested.length == 0) {
            return null;
        }
        return this.nested[0];
    }

    public Throwable initCause(Throwable throwable) {
        throw new JDOFatalInternalException(msg.msg("ERR_CannotInitCause"));
    }

    public String toString() {
        Object object;
        int n = this.nested == null ? 0 : this.nested.length;
        StringBuffer stringBuffer = new StringBuffer(10 + 100 * n);
        stringBuffer.append(super.toString());
        if (this.failed != null) {
            stringBuffer.append(MSG_FAILED_OBJECT);
            object = null;
            try {
                object = this.failed.toString();
            }
            catch (Exception exception) {
                object = msg.msg("MSG_ExceptionGettingFailedToString", exception.toString());
            }
            stringBuffer.append((String)object);
        }
        if (n > 0) {
            stringBuffer.append(MSG_NESTED_THROWABLES);
            object = this.nested[0];
            stringBuffer.append(object == null ? "null" : ((Throwable)object).toString());
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append("\n");
                object = this.nested[n2];
                stringBuffer.append(object == null ? "null" : ((Throwable)object).toString());
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        int n = this.nested == null ? 0 : this.nested.length;
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            super.printStackTrace(printStream);
            if (n > 0) {
                printStream.println(MSG_NESTED_THROWABLES_STACK_TRACE);
                int n2 = 0;
                while (n2 < n) {
                    Throwable throwable = this.nested[n2];
                    if (throwable != null) {
                        throwable.printStackTrace(printStream);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        int n = this.nested == null ? 0 : this.nested.length;
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            super.printStackTrace(printWriter);
            if (n > 0) {
                printWriter.println(MSG_NESTED_THROWABLES_STACK_TRACE);
                int n2 = 0;
                while (n2 < n) {
                    Throwable throwable = this.nested[n2];
                    if (throwable != null) {
                        throwable.printStackTrace(printWriter);
                    }
                    ++n2;
                }
            }
        }
    }
}

