/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.typehandler;

import com.ibatis.db.sqlmap.ParameterMapping;
import com.ibatis.db.sqlmap.ResultMapping;
import com.ibatis.db.sqlmap.typehandler.BaseTypeHandler;
import com.ibatis.db.sqlmap.value.StringValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StringTypeHandler
extends BaseTypeHandler {
    private static final int BUFFER_SIZE = 2048;

    protected Object getValueByName(ResultMapping resultMapping, ResultSet resultSet) throws SQLException {
        int n = resultMapping.getJdbcType();
        String string = null;
        if (-99999 == n) {
            string = resultSet.getString(resultMapping.getColumnName());
        } else if (2005 == n) {
            Clob clob = resultSet.getClob(resultMapping.getColumnName());
            if (clob != null) {
                Reader reader = clob.getCharacterStream();
                string = StringTypeHandler.readerToString(reader);
            }
        } else if (-1 == n) {
            Reader reader = resultSet.getCharacterStream(resultMapping.getColumnName());
            string = StringTypeHandler.readerToString(reader);
        } else {
            string = resultSet.getString(resultMapping.getColumnName());
        }
        return string;
    }

    protected Object getValueByIndex(ResultMapping resultMapping, ResultSet resultSet) throws SQLException {
        int n = resultMapping.getJdbcType();
        String string = null;
        if (-99999 == n) {
            string = resultSet.getString(resultMapping.getColumnIndex());
        } else if (2005 == n) {
            Clob clob = resultSet.getClob(resultMapping.getColumnIndex());
            if (clob != null) {
                Reader reader = clob.getCharacterStream();
                string = StringTypeHandler.readerToString(reader);
            }
        } else if (-1 == n) {
            Reader reader = resultSet.getCharacterStream(resultMapping.getColumnIndex());
            string = StringTypeHandler.readerToString(reader);
        } else {
            string = resultSet.getString(resultMapping.getColumnIndex());
        }
        return string;
    }

    protected Object getNullValue(String string) throws SQLException {
        return string;
    }

    public Object instantiateValue() {
        return new StringValue();
    }

    public boolean isEqualToNullValue(String string, Object object) {
        return string.equals(object);
    }

    public boolean isSimpleType() {
        return true;
    }

    public void setParameter(ParameterMapping parameterMapping, PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        int n2 = parameterMapping.getJdbcType();
        String string = (String)object;
        if (-99999 == n2) {
            preparedStatement.setString(n, string);
        } else if (2005 == n2 || -1 == n2) {
            StringReader stringReader = new StringReader(string);
            preparedStatement.setCharacterStream(n, (Reader)stringReader, string.length());
        } else {
            preparedStatement.setString(n, string);
        }
    }

    private static String readerToString(Reader reader) throws SQLException {
        String string = null;
        try {
            if (reader != null) {
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[2048];
                int n = 0;
                while ((n = reader.read(cArray)) > 0) {
                    stringBuffer.append(cArray, 0, n);
                }
                string = stringBuffer.toString();
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Error reading character stream. Cause: " + iOException);
        }
        return string;
    }
}

