/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.object.RdbmsOperation;
import org.springframework.jdbc.support.JdbcUtils;

public abstract class SqlOperation
extends RdbmsOperation {
    private int resultSetType = 1003;
    private boolean updatableResults = false;
    private PreparedStatementCreatorFactory preparedStatementFactory;

    protected void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    protected int getResultSetType() {
        return this.resultSetType;
    }

    protected void setUpdatableResults(boolean updatableResults) {
        this.updatableResults = updatableResults;
    }

    protected boolean isUpdatableResults() {
        return this.updatableResults;
    }

    protected final void compileInternal() {
        int bindVarCount = 0;
        try {
            bindVarCount = JdbcUtils.countParameterPlaceholders(this.getSql(), '?', '\'');
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidDataAccessApiUsageException(ex.getMessage());
        }
        if (bindVarCount != this.getDeclaredParameters().size()) {
            throw new InvalidDataAccessApiUsageException("SQL '" + this.getSql() + "' requires " + bindVarCount + " bind variables, but " + this.getDeclaredParameters().size() + " variables were declared for this object");
        }
        this.preparedStatementFactory = new PreparedStatementCreatorFactory(this.getSql(), this.getDeclaredParameters());
        this.preparedStatementFactory.setResultSetType(this.resultSetType);
        this.preparedStatementFactory.setUpdatableResults(this.updatableResults);
        this.onCompileInternal();
    }

    protected void onCompileInternal() {
    }

    protected PreparedStatementCreator newPreparedStatementCreator(Object[] params) {
        return this.preparedStatementFactory.newPreparedStatementCreator(params);
    }
}

