package spring.sample.dao.sample;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * DaoSampleJDBCۉt[[N𗘗p<br>
 * PERSONe[uւ́AQ,XV,ǉ,폜Ȃ<br>
 * Tvł
 * <br>
 * @author MBeans
 * @version 1.0
 */
public class DaoSample {

	private static SampleDAO getDAO() {
		BeanFactory factory = new ClassPathXmlApplicationContext("/spring/sample/dao/sample/applicationContext-jdbc.xml");
		return (SampleDAO) factory.getBean("sampleDAO");
	}

	public static void main(String[] args) throws Exception {
		//QƂ̃Tv
		selectSample();
		
		//XṼTv
		updateSample();
		
		//ǉ̃Tv
		insertSample();
		
		//폜̃Tv
		deleteSample();
		
	}

	/**
	 * PERSONe[uւ̎QƂsȂTv
	 */
	private static void selectSample() {

		SampleDAO sampleDAO = getDAO();

		List personList = sampleDAO.findPersons();
		
		Person person = null;
		System.out.println("========== Q(SELECT)̃Tv ==========");
		for (int i = 0; i < personList.size(); i++) {
			person = (Person) personList.get(i);
			System.out.println(
				"SampleDAO.findPersons ID["
					+ person.getId()
					+ "] NAME["
					+ person.getName()
					+ "] ADDRESS["
					+ person.getAddress()
					+ "]");
		}
		
		System.out.println();
	}

	/**
	 * PERSONe[uւ̍XVsȂTv
	 */
	private static void updateSample() {

		SampleDAO sampleDAO = getDAO();

		Person person = sampleDAO.findPerson("A001");
		System.out.println("========== XV(UPDATE)̃Tv ==========");
		System.out.println("---------XVO---------");
		System.out.println(
			"SampleDAO.findPerson ID["
				+ person.getId()
				+ "] NAME["
				+ person.getName()
				+ "] ADDRESS["
				+ person.getAddress()
				+ "]");
		
		Date date = new Date();
		
		person.setAddress("City " + date.getMinutes() + ":" + date.getSeconds());
		sampleDAO.updatePerson(person);
		
		person = sampleDAO.findPerson("A001");
		
		System.out.println("---------XV---------");
		System.out.println(
			"SampleDAO.findPersons ID["
				+ person.getId()
				+ "] NAME["
				+ person.getName()
				+ "] ADDRESS["
				+ person.getAddress()
				+ "]");
				
		System.out.println();
	}
	
	/**
	 * PERSONe[uւ̒ǉsȂTv
	 */
	private static void insertSample() {

		SampleDAO sampleDAO = getDAO();

		//ǉOPERSONe[ȗSf[^擾܂
		List personList = sampleDAO.findPersons();

		Person person = null;
		System.out.println("========== ǉ(INSERT)̃Tv ==========");		
		System.out.println("---------ǉO---------");
		for (int i = 0; i < personList.size(); i++) {
			person = (Person) personList.get(i);
			System.out.println(
				"SampleDAO.findPersons ID["
					+ person.getId()
					+ "] NAME["
					+ person.getName()
					+ "] ADDRESS["
					+ person.getAddress()
					+ "]");
		}
		
		//f[^ǉ܂
		Person addPerson = new Person("A999","Y","s");
		sampleDAO.addPerson(addPerson);
	
		//ǉꂽƂmFׂɁAPERSONe[ȗSf[^擾܂B
		personList = sampleDAO.findPersons();

		person = null;
		System.out.println("---------ǉ---------");		
		for (int i = 0; i < personList.size(); i++) {
			person = (Person) personList.get(i);
			System.out.println(
				"SampleDAO.findPersons ID["
					+ person.getId()
					+ "] NAME["
					+ person.getName()
					+ "] ADDRESS["
					+ person.getAddress()
					+ "]");
		}
		
		System.out.println();
	}

	/**
	 * PERSONe[uւ̍폜sȂTv
	 */
	private static void deleteSample() {

		SampleDAO sampleDAO = getDAO();

		//폜OPERSONe[ȗSf[^擾܂
		List personList = sampleDAO.findPersons();

		Person person = null;
		System.out.println("========== 폜(DELETE)̃Tv ==========");		
		System.out.println("---------폜O---------");
		for (int i = 0; i < personList.size(); i++) {
			person = (Person) personList.get(i);
			System.out.println(
				"SampleDAO.findPersons ID["
					+ person.getId()
					+ "] NAME["
					+ person.getName()
					+ "] ADDRESS["
					+ person.getAddress()
					+ "]");
		}
		
		//f[^폜܂
		Person addPerson = new Person("A999","Y","s");
		sampleDAO.deletePerson(addPerson);
	
		//폜ꂽƂmFׂɁAPERSONe[ȗSf[^擾܂B
		personList = sampleDAO.findPersons();

		person = null;
		System.out.println("---------폜---------");		
		for (int i = 0; i < personList.size(); i++) {
			person = (Person) personList.get(i);
			System.out.println(
				"SampleDAO.findPersons ID["
					+ person.getId()
					+ "] NAME["
					+ person.getName()
					+ "] ADDRESS["
					+ person.getAddress()
					+ "]");
		}
		
		System.out.println();
	}
}