/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h> //gethostbyname
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include "main.h"
#include "protocol.h"
#include "mchord.h"
#include "misc.h"
#include "app_list.h"
#include "app.h"
#include "config.h"


//global
MChord   *pMChord;
Protocol *pProtocol;


int main( int argc, char *argv[] )
{

  int  sock;
  int  port;
  int  log_flg;
  char cache_dir[256];

  cache_dir[0] = '\0';
  port = 0;
  log_flg = 0;

  //decode option
  //          in    in    out    out        out
  if((Options(argc, argv, &port, cache_dir, &log_flg)) == -1){
    return -1;
  }
  

  //initialize class
  pMChord   = new MChord(port, cache_dir, log_flg);
  pProtocol = new Protocol();
  
  app_gtk_init(&argc, &argv);
  
  return(0);       

}


