/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

void Usage(){
  printf("mchord 1.0a  2004 .Feb\n");
  fprintf(stderr, "usage: ./matchan[-hcp]\n");
  fprintf(stderr, "  -h              - this message\n");
  fprintf(stderr, "  -c CacheDir     - cache directory\n");
  fprintf(stderr, "  -p PortNumber   - port number\n");
  fprintf(stderr, "  -l              - output logfile to stderr\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "ex) ./mchord -p 5555\n");
  fprintf(stderr, "ex) ./mchord -p 5555 -c cache\n");
  
}


//FALSE=0
//TRUE=-1,1
int Options(int argc, char *argv[], int *port , char *cache_dir, int *log_flg){

  char c;

  while((c = getopt(argc, argv, "ht:i:c:p:o:w:l")) != -1){

    switch(c){
    case 'h': //help
      Usage();
      return(0);
      break;

    case 'c':
      *cache_dir = '\0';
      strcpy(cache_dir, optarg);
      break;

    case 'p': //input iplist
      *port = atoi(optarg);
      break;
      
    case 'l':
      *log_flg = 1;
      break;

    default: //unknown option
      fprintf(stderr, "Error: Illegal Option '%c'!!\n", c);
      Usage();
      return(0);
      break;
    }

  }


  //error
  if(*port < 0){
    fprintf(stderr, "Error: port number error !!\n");
    return 0;
  }


  return 1;

}


