/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>

char *host_to_ipstr(char *hostname){

  struct hostent *myhost;
  struct in_addr *aptr;

  if((myhost = (struct hostent *)gethostbyname(hostname)) == NULL) {
    fprintf(stderr,"bad hostname! /etc/hosts is correct?\n");
    return NULL;
  }  
  
  aptr = (struct in_addr *)*myhost->h_addr_list;
  //fprintf(stderr, "gethostbyname%s\n",inet_ntoa(*aptr));
  return inet_ntoa(*aptr);
  
  
}

char *GetMyIp(void){
  char hostname[257];
  struct hostent *myhost;
  struct in_addr *aptr;

  gethostname(hostname, 256);
  if((myhost = (struct hostent *)gethostbyname(hostname)) == NULL) {
    fprintf(stderr,"bad hostname! /etc/hosts is correct?\n");
    return NULL;
  }  
  
  aptr = (struct in_addr *)*myhost->h_addr_list;
  //fprintf(stderr, "gethostbyname%s\n",inet_ntoa(*aptr));
  return inet_ntoa(*aptr);
  
}
