/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/

#ifndef __TASKLIST
#define __TASKLIST
#include "inc.h"
enum TYPE {T_EVENT, T_DATA, T_UPDATE_RT, T_FILE};

typedef struct _TASKLIST {

  //join(join,file) chain some packet
  //SequcenceNo,sessid
  //
  //lookup(1packet only)
  //SequenceNo, sessid=SequenceNo

  //T_UPDATE_RT
  TYPE Type; //T_EVENT,T_DATA,T_UPDATE_RT
  int  SeqNo; 
  int  RetransmitCount; //retransmit timeout
  int  McId; //T_FILE,T_DATA, 


  //T_DATA
  ADDRESS Address;
  int     Func;  //M_ACK,etc.,
  int     Size;
  int     SessId;//app_sessid
  char   *Data;  // need free
  ADDRESS Next;  //M_JOIN_ACCEPT
  int     Ans;   //LOOKUP_RESPONSE
  int     Ttl;   //LOOKUP_RESPONSE

  //T_FILE
  FILE *Fp; /*need close*/
  int   FileSeqNo;
  int   Flag;


  struct _TASKLIST *prev;
  struct _TASKLIST *next;
}TASKLIST;

#endif


TASKLIST *task_insert(TASKLIST **phead, ADDRESS address);
TASKLIST *task_delete_key(TASKLIST **phead, ADDRESS address);
TASKLIST *task_delete(TASKLIST **phead, TASKLIST *pdel);

TASKLIST *task_search(TASKLIST *plist, int fd);//fdǸpLIST֤
TASKLIST *task_search_sequenceno(TASKLIST *plist, int session);
int task_size(TASKLIST *plist);
void task_print(TASKLIST **plist);



