/*
 * Copyright (C) 2005 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t handle_s();
const commandtable_t command_handle =
	{"handle", handle_s, "address", "print handle_t"};
extern addr_t print_handle();
extern void prhead_handle();

PRIVATE addr_t journal_s();
const commandtable_t command_journal =
	{"journal", journal_s, "address", "print journal_t"};
extern addr_t print_journal();
extern void prhead_journal();

PRIVATE addr_t
handle_s()
{
	addr_t addr = 0;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		THROW(usage);
	}

	prhead_handle();
	while (args[optind]) {
		addr = print_handle(getvalue(args[optind]));
		optind++;
	}
	return addr;
}

PRIVATE addr_t
journal_s()
{
	addr_t addr = 0;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		THROW(usage);
	}

	prhead_journal();
	while (args[optind]) {
		addr = print_journal(getvalue(args[optind]));
		optind++;
	}
	return addr;
}
