/*
 * Copyright (C) 2000-2005 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/spinlock.h>
#include <linux/slab.h>
#include <linux/init.h>
#include "flags_slab.h"
#ifdef _slab_rcu_has_head
#include <linux/rcupdate.h>
#endif
#include "slab.h"

addr_t print_slab();
addr_t print_kmem_cache();

void
prhead_slab()
{
	mprintf(SPTR" "SPTR" COL "SPTR" INU FREE\n",
		"ADDR", "NEXT", "S_MEM");
}

addr_t
print_slab(addr, num)
	addr_t addr;
	int num;
{
#ifndef NO_SUCH_FILE
	struct slab slab;
	kmem_bufctl_t buf[512], ix = slab.free;

	memread(addr, sizeof(slab), &slab, "slab_t");
	mprintf(FPTR " ", addr);

	mprintf(FPTR " %3lx " FPTR " %3x", slab.list.next, slab.colouroff, slab.s_mem, slab.inuse);

	if (slab.free == BUFCTL_END) {
		ix = slab.inuse;
		mprintf(" -\n");
	} else {
		if (num == 0 || num > LENGTHOF(buf)) {
			num = LENGTHOF(buf);
		}
		ix = slab.free;
		memread(addr + sizeof(slab), sizeof(buf[0]) * num, buf, "slab_t");
		while (1) {
			if (ix >= num) {
				mprintf(" ?\n");
				return 0;
			}
			mprintf(" %x", ix);
			if (buf[ix] == BUFCTL_END)
				break;
			else if (buf[ix] == ix) {
				mprintf("...?\n");
				return 0;
			}
			ix = buf[ix];
		}
		mprintf("\n");
	}
	return (addr_t)slab.list.next - OFFSET(struct slab, list);
#endif
}

addr_t
print_kmem_list3(addr, num)
	addr_t addr;
	int num;
{
#ifndef NO_SUCH_FILE
	struct kmem_list3 list3;

	memread(addr, sizeof(list3), &list3, "kmem_list3");
	mprintf(FPTR " ", addr);
	mprintf("slabs_full    " FPTR " " FPTR "\n",
		list3.slabs_full.next, list3.slabs_full.prev);
	mprintf("slabs_partial " FPTR " " FPTR "\n",
		list3.slabs_partial.next, list3.slabs_partial.prev);
	mprintf("slabs_free    " FPTR " " FPTR "\n",
		list3.slabs_free.next, list3.slabs_free.prev);
	mprintf("free_objects  %lx\n", list3.free_objects);
	mprintf("free_touched  %x\n",  list3.free_touched);
	mprintf("next_reap     %lx\n", list3.next_reap);

	if (num > 0) {
		addr_t sad;
		int none;
		mprintf("slabs_full:\n");
		prhead_slab();
		sad = (addr_t)list3.slabs_full.next - OFFSET(struct slab, list);
		none = 1;
		while (sad && sad != addr + OFFSET(struct kmem_list3, slabs_full)) {
			sad = print_slab(sad, num);
			none = 0;
		}
		if (none)
			mprintf(SPTR"\n", "(none)");

		mprintf("slabs_partial:\n");
		prhead_slab();
		sad = (addr_t)list3.slabs_partial.next - OFFSET(struct slab, list);
		none = 1;
		while (sad && sad != addr + OFFSET(struct kmem_list3, slabs_partial)) {
			sad = print_slab(sad, num);
			none = 0;
		}
		if (none)
			mprintf(SPTR"\n", "(none)");
	}
	return 0;
#endif
}

void
prhead_kmem_cache()
{
	mprintf(SPTR"  SIZE NUM  COL COFF NEXT  NAME\n", "ADDR");
}

addr_t
print_kmem_cache(addr, sflag, full, next)
	addr_t addr;
	int sflag;
	int full;
	int next;
{
#ifndef NO_SUCH_FILE
	kmem_cache_t cache;
	char name[64];
	const char *p;

	if (next) {
		addr -= OFFSET(kmem_cache_t, next);
	}
	memread(addr, sizeof(cache), &cache, "kmem_cache_t");
	memread((addr_t)cache.name, sizeof(name), name, "kmem_cache_t");

	if (!full) {
		mprintf(FPTR " %5x %3x %4lx %4x %4x  ",
			addr, cache.objsize, cache.num, cache.colour,
			cache.colour_off, cache.colour_next);
		mprintstr(name, sizeof(name));
		mprintf("\n");

	} else {
		mprintf("addr: " FPTR "\n", addr);
#if defined(_kmem_cache_has_array) || defined(_kmem_cache_s_has_array)
		int i;

		mprintf("array[%x]    ", NR_CPUS);
		{	int i;
			for (i = 0; i < NR_CPUS; i++) {
				if (cache.array[i])
					mprintf(" " FPTR, cache.array[i]);
				else
					mprintf(" -");
			}
		}
		mprintf("\n");
#endif
#if defined(_kmem_cache_has_batchcount) || defined(_kmem_cache_s_has_batchcount)
		mprintf("batchcount   %x\n", cache.batchcount);
#endif
#if defined(_kmem_cache_has_limit) || defined(_kmem_cache_s_has_limit)
		mprintf("limit        %x\n", cache.limit);
#endif
#if defined(_kmem_cache_has_shared) || defined(_kmem_cache_s_has_shared)
		mprintf("shared       %x\n", cache.shared);
#endif
		mprintf("objsize      %x\n", cache.objsize);
#if defined(_kmem_cache_s_has_nodelists) ||defined(_kmem_cache_has_nodelists)
		mprintf("nodelists[%x]", MAX_NUMNODES);
		{	int i;
			for (i = 0; i < MAX_NUMNODES; i++)
				mprintf(" " FPTR, cache.nodelists[i]);
			mprintf("\n");
		}
#endif
		mprintf("flags        %x\n", cache.flags);
		mprintf("num          %x\n", cache.num);
#if defined(_kmem_cache_has_free_limit) || defined(_kmem_cache_s_has_free_limit)
		mprintf("free_limit   %x\n", cache.free_limit);
#endif
		mprintf("gfporder     %x\n", cache.gfporder);
		mprintf("gfpflags     %x\n", cache.gfpflags);
		mprintf("colour       %lx\n", cache.colour);
		mprintf("colour_off   %x\n", cache.colour_off);
		mprintf("colour_next  %x\n", cache.colour_next);
		mprintf("slabp_cache   " FPTR "\n", cache.slabp_cache);
		mprintf("dflags       %x\n", cache.dflags);
		p = getsymstr_func((addr_t)cache.ctor);
		mprintf("ctor/dtor    %s", p? p: "NULL");
		p = getsymstr_func((addr_t)cache.dtor);
		mprintf("  %s\n", p? p: "NULL");
		mprintf("name         \"");
		mprintstr(name, sizeof(name));
		mprintf("\"\n");
		mprintf("next          " FPTR " " FPTR "\n",
			cache.next.next, cache.next.prev);
	}

	if (sflag) {
#if defined(_kmem_cache_s_has_nodelists) || defined(_kmem_cache_has_nodelists)
		int i;
		for (i = 0; i < MAX_NUMNODES; i++) {
			print_kmem_list3(cache.nodelists[i], cache.num);
		}
#else
#if defined(_kmem_cache_s_has_lists)
		print_kmem_list3(addr + OFFSET(kmem_cache_t, lists), cache.num);
#endif
#endif /*_kmem_cache_has_nodelists*/
	}
	if (next) {
		return (addr_t)cache.next.next;
	} else {
		return (addr_t)cache.next.next - OFFSET(kmem_cache_t, next);
	}
#endif /*NO_SUCH_FILE*/
}

int
search_slab(addr)
	addr_t addr;
{
#ifndef NO_SUCH_FILE
	extern addr_t cache_chain_addr;
	addr_t kmaddr, saddr;
	kmem_cache_t cache;
	struct slab slab;
	char name[64];
	int len, n, cnt;

	memread(cache_chain_addr, sizeof(kmaddr), &kmaddr, "cache_chain");
	while (kmaddr && kmaddr != cache_chain_addr) {
		memread(kmaddr - OFFSET(kmem_cache_t, next), sizeof(cache), &cache, "kmem_cache_t");
		len = cache.objsize * cache.num;
		cnt = 0;

#if defined(_kmem_cache_s_has_nodelists) || defined(_kmem_cache_has_nodelists)
		int i;
		for (i = 0; i < MAX_NUMNODES; i++) {
			struct kmem_list3 nlist;
			if (cache.nodelists[i] == NULL)
				continue;
			memread((addr_t)cache.nodelists[i], sizeof(nlist),
				&nlist, "kmem_list3");

			saddr = (addr_t)nlist.slabs_full.next - OFFSET(struct slab, list);
			while (saddr && saddr != (addr_t)cache.nodelists[i] + OFFSET(struct kmem_list3, slabs_full)) {
				memread(saddr, sizeof(slab), &slab, "slab_t");
				if (addr >= (addr_t)slab.s_mem && addr < (addr_t)slab.s_mem + len)
					goto found;
				saddr = (addr_t)slab.list.next - OFFSET(struct slab, list);
				if (++cnt > 100000) {
					mprintf("loop? (%lx full)\n", kmaddr);
					break;
				}

			}
			cnt = 0;
			saddr = (addr_t)nlist.slabs_partial.next - OFFSET(struct slab, list);
			while (saddr && saddr != (addr_t)cache.nodelists[i] + OFFSET(struct kmem_list3, slabs_partial)) {
				memread(saddr, sizeof(slab), &slab, "slab_t");
				if (addr >= (addr_t)slab.s_mem && addr < (addr_t)slab.s_mem + len)
					goto found;
				saddr = (addr_t)slab.list.next - OFFSET(struct slab, list);
				if (++cnt > 100000) {
					mprintf("loop? (%lx partial)\n", kmaddr);
					break;
				}
			}
		}

#else /*_kmem_cache_has_nodelists*/
		saddr = (addr_t)cache.lists.slabs_full.next - OFFSET(struct slab, list);
		while (saddr && saddr != kmaddr - OFFSET(kmem_cache_t, next) + OFFSET(kmem_cache_t, lists.slabs_full)) {
			memread(saddr, sizeof(slab), &slab, "slab_t");
			if (addr >= (addr_t)slab.s_mem && addr < (addr_t)slab.s_mem + len)
				goto found;
			saddr = (addr_t)slab.list.next - OFFSET(struct slab, list);
			if (++cnt > 100000) {
				mprintf("loop? (%lx full)\n", kmaddr);
				break;
			}

		}
		cnt = 0;
		saddr = (addr_t)cache.lists.slabs_partial.next - OFFSET(struct slab, list);
		while (saddr && saddr != kmaddr - OFFSET(kmem_cache_t, next) + OFFSET(kmem_cache_t, lists.slabs_partial)) {
			memread(saddr, sizeof(slab), &slab, "slab_t");
			if (addr >= (addr_t)slab.s_mem && addr < (addr_t)slab.s_mem + len)
				goto found;
			saddr = (addr_t)slab.list.next - OFFSET(struct slab, list);
			if (++cnt > 100000) {
				mprintf("loop? (%lx partial)\n", kmaddr);
				break;
			}
		}
#endif /*_kmem_cache_has_nodelists*/
		kmaddr = (addr_t)cache.next.next;
	}

	return 0;	/* not found */
found:
	memread((addr_t)cache.name, sizeof(name), name, "kmem_cache_t");
	n = (addr - (addr_t)slab.s_mem) / cache.objsize;
	mprintf("slab \"%s\" offset %lx ", name,
		(addr - (addr_t)slab.s_mem) - n * cache.objsize);

	if (slab.free == BUFCTL_END) {
		mprintf("inuse\n");
	} else {
		int num = cache.num;
		kmem_bufctl_t buf[512], ix = slab.free;

		if (num > LENGTHOF(buf))
			num = LENGTHOF(buf);
		ix = slab.free;
		memread(saddr + sizeof(slab), sizeof(buf[0]) * num, buf, "slab_t");
		while (1) {
			if (ix == n) {
				mprintf("free\n");
				break;
			} else if (ix < 0 || ix >= num) {
				mprintf("unknown\n");
				break;
			} else if (buf[ix] == BUFCTL_END) {
				mprintf("inuse\n");
				break;
			}
			ix = buf[ix];
		}
	}
#endif
	return 1;
}
