/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#ifndef DEF_H
#define DEF_H

#include "config.h"

#ifndef NOCONFIG
#include <linux/autoconf.h>
#endif

#ifdef DEBUG
#define PRIVATE
#else
#define PRIVATE static
#endif

#define	LENGTHOF(x)	(sizeof(x)/sizeof(x[0]))

typedef unsigned long addr_t;		/* virtual/physical address */

typedef struct bitname {
	long value;
	const char *name;
} bitname_t;

typedef struct symtable {
	struct symtable *next;		/* hash queue */
	addr_t addr;			/* virtual address */
	char *name;			/* symbol name */
	char type;
	char nbuf[15];
} symtable_t;
extern symtable_t *symtable;

typedef struct sizetbl {
	char *name;
	unsigned int size;
} sizetbl_t;
extern sizetbl_t sizetbl[];
extern int sizetbl_size;

#if PTRSIZE==8
#define	FPTR	"%16lx"
#define	SPTR	"%16s"
#else
#define	FPTR	"%8lx"
#define	SPTR	"%8s"
#endif

#define	ATOMIC_READ(x)	((x).counter)

#define	OFFSET(typ,x)	((size_t)&((typ *)0)->x)

typedef enum prmode {
	BYBYTE = 1, BYHALFWORD = 2, BYWORD = 4, BYDOUBLE = 8,
	PRNOCHAR = 16
} prmode_t;
#define	PRMASK	(BYBYTE|BYHALFWORD|BYWORD|BYDOUBLE)

#ifdef __STDC__
extern void addsym(const char *name, addr_t value, int type);
extern addr_t getvalue(const char *str);
extern addr_t pa(addr_t);
extern void memread(addr_t addr, addr_t size, void *buf, const char *errmsg);
extern void ll_memread(addr_t addr, addr_t size, void *buf, const char *errmsg);
extern void load_pgd(addr_t addr);
extern addr_t translate_addr(addr_t addr, addr_t *count, const char *errmsg);
extern addr_t searchaddr_bysym(const char *name);
extern const struct symtable *searchsym_byaddr(addr_t addr);
extern const char *getsymstr(addr_t addr);
extern const char *getsymstr_func(addr_t addr);
extern void printxd(const unsigned char *p, addr_t addr, int size, prmode_t);
extern void mprintf(const char *fmt, ...)
	__attribute__ ((format (printf, 1, 2)));
extern void mprintbit(const struct bitname *, long);
extern int  mprintstr(const unsigned char *p, int maxlen);
extern void mprint_mode(int);
extern unsigned int m_ntohl(unsigned int);
extern unsigned short m_ntohs(unsigned short);
extern void *m_memcpy(void *dest, const void *src, int n);
extern int search_slab(addr_t addr);
extern int search_task(addr_t addr);
extern void vers_init(void);
extern int getmsyms_fromfile(const char *, addr_t, addr_t, addr_t);
extern int getinfo_fromtask(addr_t addr, addr_t *ip, addr_t *sp, addr_t *stack);
struct semaphore;
extern void mprint_semaphore(struct semaphore *);
#if PATCHLEVEL>=6 && SUBLEVEL>=16
struct mutex;
extern void mprint_mutex(struct mutex *);
#endif
extern void mprint_jif(unsigned long);

extern addr_t init_task_addr;
#endif /*__STDC__*/

#endif /*DEF_H*/
