/*
 * Copyright (C) 2000-2006 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#if defined(XFS_NOPAGEBUF_H)
#include <linux/types.h>
#include <linux/fs.h>
#include <linux/sched.h>
#include <xfs_types.h>
#include <xfs_cred.h>
#include <xfs_lrw.h>
#include <xfs_buf.h>
#else /*XFS_NOPAGEBUF_H*/
#if defined(XFS_OLDDIR)
#define _PAGE_BUF_INTERNAL_
#include <linux/fs.h>
#include <linux/page_buf.h>
#else /*XFS_OLDDIR*/
#ifdef HAVE_AVL
#include <avl.h>
#endif
#include <linux/slab.h>	/* for old version */
#include <page_buf.h>
#ifdef HAVE_PB_INTERNAL
#include <page_buf_internal.h>
#endif
#endif /*XFS_OLDDIR*/
#endif /*XFS_NOPAGEBUF_H*/

#include "flags_pagebuf.h"

extern void prhead_semaphore();
extern addr_t print_semaphore();

void
prhead_pagebuf()
{
	mprintf(SPTR" "SPTR" HD       BN LENG "SPTR" ERR CNT OFFS "SPTR" FLAGS\n",
		"ADDR", "TARGET", "ADDR", "PAGES");
}

PRIVATE void
S(p)
	addr_t p;
{
	if (p) {
		mprintf("%s\n", getsymstr_func(p));
	} else {
		mprintf("-\n");
	}
}

#ifdef XB_PAGES

print_pagebuf(addr, fflag)
	addr_t addr;
	int fflag;
{
	struct xfs_buf xb;

	mprintf(FPTR " ", addr);
	memread(addr, sizeof(xb), &xb, "xfs_buf");

	mprintf(FPTR, xb.b_target);
	mprintf(" %2x", xb.b_hold);
	mprintf(" %8lx", xb.b_bn);
	mprintf(" %4lx", xb.b_buffer_length);
	mprintf(" " FPTR, xb.b_addr);
	mprintf(" %3x", xb.b_error);
	mprintf(" %3x", xb.b_page_count);
	mprintf(" %4x", xb.b_offset);
	mprintf(" " FPTR, xb.b_pages);
	//mprintbit(xfs_buf_flags_t_bitname, xb.b_flags);
	mprintf("\n");

	if (fflag & 1) {
		mprintf("  iodone: " FPTR "  ", xb.b_iodone);
		S(xb.b_iodone);
		mprintf("  relse:  " FPTR "  ", xb.b_relse);
		S(xb.b_relse);
		mprintf("  strat:  " FPTR "  ", xb.b_strat);
		S(xb.b_strat);
		mprintf("  locked:      %x\n", xb.b_locked);
		mprintf("  fspriv  " FPTR "  (xfs_log_item)\n", xb.b_fspriv);
		mprintf("  fspriv2 " FPTR "  (xfs_trans)\n", xb.b_fspriv2);
		mprintf("  fspriv3 " FPTR "  (xfs_mount)\n", xb.b_fspriv3);
		mprintf("  io_remainig  %x\n", ATOMIC_READ(xb.b_io_remaining));
		mprintf("  pin_count    %x\n", ATOMIC_READ(xb.b_pin_count));
		mprintf("  sema:\n");
		prhead_semaphore();
		print_semaphore(addr + OFFSET(struct xfs_buf, b_sema));
		mprintf("  iodonesema:\n");
		prhead_semaphore();
		print_semaphore(addr + OFFSET(struct xfs_buf, b_iodonesema));
#ifdef XFS_BUF_LOCK_TRACKING
		mprintf("  last_hold  %x\n", xb.b_last_holder);
#endif
	}
	return (addr_t)xb.b_list.next - OFFSET(struct xfs_buf, b_list);
}

#else /*PB_PAGES*/

#if defined(_xfs_buf_has_pb_flags) && !defined(_page_buf_s_has_pb_flags)
typedef struct xfs_buf page_buf_t;
#endif

addr_t
print_pagebuf(addr, fflag)
	addr_t addr;
	int fflag;
{
	page_buf_t pb;

#if defined(_xfs_buf_has_pb_pin_count) || defined(_page_buf_s_has_pb_pin_count)
	memread(addr, sizeof(pb), &pb, "page_buf_t");
#else
	page_buf_private_t pbp;
	memread(addr, sizeof(pbp), &pbp, "page_buf_t");
	pb = pbp.pb_common;
#endif

	mprintf(FPTR " ", addr);

	mprintf(FPTR, pb.pb_target);
	mprintf(" %2x", pb.pb_hold);
	mprintf(" %8lx", pb.pb_bn);
	mprintf(" %4lx", pb.pb_buffer_length);
	mprintf(" " FPTR, pb.pb_addr);
	mprintf(" %3x", pb.pb_error);
	mprintf(" %3x", pb.pb_page_count);
	mprintf(" %4x", pb.pb_offset);
	mprintf(" " FPTR, pb.pb_pages);
	mprintbit(page_buf_flags_e_bitname, pb.pb_flags);
	mprintf("\n");

	if (fflag & 1) {
		mprintf("  iodone: " FPTR "  ", pb.pb_iodone);
		S(pb.pb_iodone);
		mprintf("  relse:  " FPTR "  ", pb.pb_relse);
		S(pb.pb_relse);
		mprintf("  strat:  " FPTR "  ", pb.pb_strat);
		S(pb.pb_strat);
		mprintf("  locked:      %x\n", pb.pb_locked);
		mprintf("  fspriv  " FPTR "  (xfs_log_item)\n", pb.pb_fspriv);
		mprintf("  fspriv2 " FPTR "  (xfs_trans)\n", pb.pb_fspriv2);
		mprintf("  fspriv3 " FPTR "  (xfs_mount)\n", pb.pb_fspriv3);
#if defined(_xfs_buf_has_pb_pin_count) || defined(_page_buf_s_has_pb_pin_count)
		/* new style */
		mprintf("  io_remainig  %x\n", ATOMIC_READ(pb.pb_io_remaining));
		mprintf("  pin_count    %x\n", ATOMIC_READ(pb.pb_pin_count));
#else
		/* old fashion */
		mprintf("  io_remaining %x\n", pbp.pb_io_remaining);
		mprintf("  pin_count    %x\n", pbp.pb_pin_count);
#endif
		mprintf("  sema:\n");
		prhead_semaphore();
#if defined(_xfs_buf_has_pb_sema) || defined(_page_buf_s_has_pb_sema)
		/* new style */
		print_semaphore(addr + OFFSET(page_buf_t, pb_sema));
#else
		/* old fashion */
		print_semaphore(addr + OFFSET(struct page_buf_private_s, pb_sema));
#endif

		mprintf("  iodonesema:\n");
		prhead_semaphore();
#if defined(_xfs_buf_has_pb_iodonesema) || defined(_page_buf_s_has_pb_iodonesema)
		/* new style */
		print_semaphore(addr + OFFSET(page_buf_t, pb_iodonesema));
#else
		/* old fashion */
		print_semaphore(addr + OFFSET(struct page_buf_private_s, pb_iodonesema));
#endif
#ifdef PAGEBUF_LOCK_TRACKING
		mprintf("  last_hold  %d\n", pbp.pb_last_holder);
#endif
	}

#if defined(_xfs_buf_has_pb_hash_list) || defined(_page_buf_s_has_pb_hash_list)
	if (fflag & 2)
		return (addr_t)pb.pb_hash_list.next;
#endif
	return (addr_t)pb.pb_list.next - OFFSET(page_buf_t, pb_list);
}

#endif /*XB_PAGES*/

void
print_all_pagebuf(addr, fflag, nhash)
	addr_t addr;
	int fflag;
{
#if defined(_xfs_buf_has_pb_hash_list) || defined(_page_buf_s_has_pb_hash_list)

#ifndef NBITS
#define NBITS	8
#define NHASH	(1<<NBITS)
	typedef struct {
		struct list_head	pb_hash;
#if !defined(XFS_NOPAGEBUF_H)	/*XXX*/
		int			pb_count;
#endif /*XFS_NOPAGEBUF_H*/
		spinlock_t		pb_hash_lock;
	} pb_hash_t;
#endif /*NBITS*/

	pb_hash_t pbh;
	addr_t tmp;
	int i;

	if (nhash == 0)
		nhash = NHASH;

	prhead_pagebuf();
	for (i = 0; i < nhash; i++) {
		memread(addr + sizeof(pbh) * i, sizeof(pbh), &pbh, "pbhash");
#if !defined(XFS_NOPAGEBUF_H)	/*XXX*/
		if (pbh.pb_count == 0)
			continue;
#endif /*XFS_NOPAGEBUF_H*/
		tmp = (addr_t)pbh.pb_hash.next;
		while (tmp && tmp != addr + sizeof(pbh) * i + OFFSET(pb_hash_t, pb_hash)) {
			tmp = print_pagebuf(tmp - OFFSET(page_buf_t, pb_hash_list), fflag | 2);
		}
	}
#endif /*_page_buf_s_has_pb_hash_list*/
}

addr_t
print_xfs_buftarg(addr, bflag)
	addr_t addr;
	int bflag;
{
#ifdef _xfs_buftarg_has_pbr_dev
	struct xfs_buftarg bt;

	mprintf("addr      " FPTR "\n", addr);
	memread(addr, sizeof(bt), &bt, "xfs_buftarg");

	mprintf("dev       ");
	mprint_dev_t(bt.pbr_dev);
	mprintf("\n");
	mprintf("bdev      " FPTR "\n", bt.pbr_bdev);
	mprintf("mapping   " FPTR "\n", bt.pbr_mapping);
	mprintf("bsize     %x (2^%x)\n", bt.pbr_bsize, bt.pbr_sshift);
#ifdef _xfs_buftarg_has_bt_hash
	mprintf("hashmask  %x (2^%x)\n", bt.bt_hashmask, bt.bt_hashshift);
	mprintf("hash      " FPTR "\n", bt.bt_hash);

	if (bflag)
		print_all_pagebuf(bt.bt_hash, 0, bt.bt_hashmask + 1);
#endif /*_xfs_buftarg_has_hash*/
#endif /*_xfs_buftarg_has_pbr_dev*/

#ifdef _pb_target_has_pbr_device
	struct pb_target bt;

	mprintf("addr      " FPTR "\n", addr);
	memread(addr, sizeof(bt), &bt, "pb_target");

	mprintf("dev       ");
	mprint_kdev_t(bt.pbr_device);
	mprintf("\n");
	mprintf("blocksize %x (2^%x)\n", bt.pbr_blocksize, bt.pbr_blocksize_bits);
#ifdef _pb_target_has_pbr_bdev
	mprintf("bdev      " FPTR "\n", bt.pbr_bdev);
#endif
#ifdef _pb_target_has_pbr_mapping
	mprintf("mapping   " FPTR "\n", bt.pbr_mapping);
#endif
#ifdef _pb_target_has_pbr_addrspace
	mprintf("addrspace " FPTR "\n", bt.pbr_addrspace);
#endif
#endif /*_pb_target_has_pbr_device*/
	return 0;
}
