/*
 * Copyright (C) 2000-2005 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <xfs.h>
#include <xfs_inum.h>
#include <xfs_log.h>
#include <xfs_trans.h>
#include <xfs_sb.h>
#include <xfs_ag.h>
#include <xfs_dir.h>
#include <xfs_dir2.h>
#include <xfs_dmapi.h>
#include <xfs_quota.h>
#include <xfs_mount.h>
#include <xfs_bmap_btree.h>
#include <xfs_attr_sf.h>
#include <xfs_dir_sf.h>
#include <xfs_dir2_sf.h>
#include <xfs_dinode.h>
#include <xfs_inode.h>
#include <xfs_dquot_item.h>
#include <xfs_dquot.h>
#include <xfs_qm.h>

extern void prhead_semaphore();
extern addr_t print_semaphore();

addr_t
print_xfs_dquot(addr, fflag)
	addr_t addr;
	int fflag;
{
	struct xfs_dquot dq;

	mprintf("addr:         " FPTR " (%x)\n", addr, sizeof(dq));
	memread(addr, sizeof(dq), &dq, "xfs_dquot");

	mprintf("lists.flnext: " FPTR " " FPTR "\n", dq.q_lists.dqm_flnext, dq.q_lists.dqm_flprev);
	mprintf("hash:         " FPTR "  (xfs_dqhash)\n", dq.q_hash);
	mprintf("mount:        " FPTR "  (xfs_mount)\n", dq.q_mount);
	mprintf("transp:       " FPTR "  (xfs_trans)\n", dq.q_transp);
	mprintf("nrefs:        %x\n", dq.q_nrefs);
	mprintf("blkno:        %lx\n", dq.q_blkno);
	mprintf("bufoffset:    %x\n", dq.q_bufoffset);
	mprintf("fileoffset:   %x\n", dq.q_fileoffset);
	mprintf("gdquot:       " FPTR "\n", dq.q_gdquot);
	mprintf("core.flags:   %x\n", dq.q_core.d_flags);
	mprintf("core.id:      %x\n", m_ntohl(dq.q_core.d_id));
	mprintf("&logitem:     " FPTR "  (xfs_log_item)\n", addr + OFFSET(struct xfs_dquot, q_gdquot));
	mprintf("b/i/rtb:      %x/%x/%x\n", dq.q_res_bcount, dq.q_res_icount, dq.q_res_rtbcount);
	mprintf("pincount:     %x\n", dq.q_pincount);
#ifdef DQUOT_TRACING
	mprintf("trace:        " FPTR "\n", dq.q_trace);
#endif

	return (addr_t)dq.q_lists.dqm_flnext;
}

void
prhead_xfs_dqhash()
{
	mprintf("SLOT " SPTR " " SPTR "  VERSION NELEMS\n",
		"ADDR", "NEXT");
}

addr_t
print_xfs_dqhash(addr, n, fflag)
	addr_t addr;
	int n;
	int fflag;
{
	struct xfs_dqhash dqh;

	addr += n * sizeof(dqh);
	memread(addr, sizeof(dqh), &dqh, "xfs_dqhash_t");
	mprintf("%4x " FPTR " " FPTR " %8x %6x\n",
		n, addr, dqh.qh_next, dqh.qh_version, dqh.qh_nelems);
	return (addr_t)dqh.qh_next;
}

addr_t
print_xfs_quotainfo(addr, fflag)
	addr_t addr;
	int fflag;
{
	struct xfs_quotainfo qi;

	mprintf("addr:         " FPTR " (%x)\n", addr, sizeof(qi));
	memread(addr, sizeof(qi), &qi, "xfs_quotainfo");

	mprintf("uquotaip:     " FPTR "  (xfs_inode)\n", qi.qi_uquotaip);
	mprintf("gquotaip:     " FPTR "  (xfs_inode)\n", qi.qi_gquotaip);
	mprintf("dqlist.next   " FPTR "  (xfs_dquot)\n", qi.qi_dqlist.qh_next);
	mprintf("dqlist.nelems %x\n", qi.qi_dqlist.qh_nelems);
	mprintf("dqreclaims:   %x\n", qi.qi_dqreclaims);
	mprintf("btimelimit:   %lx  (date)\n", qi.qi_btimelimit);
	mprintf("itimelimit:   %lx  (date)\n", qi.qi_itimelimit);
	mprintf("rtbtimelimit: %lx  (date)\n", qi.qi_rtbtimelimit);
	return 0;
}

addr_t
print_xfs_qm(addr, fflag)
	addr_t addr;
	int fflag;
{
	struct xfs_qm qm;

	mprintf("addr:         " FPTR " (%x)\n", addr, sizeof(qm));
	memread(addr, sizeof(qm), &qm, "xfs_qm");

	mprintf("usr_dqhtable: " FPTR "  (xfs_dqhash)\n", qm.qm_usr_dqhtable);
	mprintf("grp_dqhtable: " FPTR "  (xfs_dqhash)\n", qm.qm_grp_dqhtable);
	mprintf("dqhashmask:   %x\n", qm.qm_dqhashmask);
	mprintf("dqfreelist.n: %x\n", qm.qm_dqfreelist.qh_nelems);
	mprintf("totaldquots:  %x\n", qm.qm_totaldquots);
	mprintf("nrefs:        %x\n", qm.qm_nrefs);
	mprintf("dqfree_ratio: %x\n", qm.qm_dqfree_ratio);
	mprintf("dqzone:       " FPTR "\n", qm.qm_dqzone);
	mprintf("dqtrxzone:    " FPTR "\n", qm.qm_dqtrxzone);

	return (addr_t) qm.qm_dqfreelist.qh_next;
}
